export default {

    data() {
        return {
            loading: true,
            result: null,
        }
    },

    props: {

        webhook: {
            type: Object,
            default: null
        },
    },

    mounted() {
        this.trigger();
    },

    computed: {
        duration() {

            if (!this.result) return 0;
            if (!this.result.duration_ms) return 0;

            return this.result?.duration_ms / 1000;
        }
    },

    methods: {

        trigger() {

            this.loading = true;

            this.$request('/webhooks/trigger', {webhook: this.webhook}).then(resp => {

                this.result = resp.result;

                console.log('TRIGGER RESPONSE:', resp.result);

            }).catch(resp => {
                App.ui.notify(resp.error || 'Triggering webhook failed!', 'error');
            }).finally(() => {
                this.loading = false;
            });


        }
    },

    template: /*html*/`
        <div>

            <div class="kiss-flex kiss-flex-middle kiss-size-4 kiss-text-bold" gap="small">
                <div :class="loading ? 'kiss-color-muted': (result.success ? 'kiss-color-success':'kiss-color-danger')"><kiss-svg :src="$baseUrl('webhooks:icon.svg')" width="30" height="30"></kiss-svg></div>
                <span v-if="loading">{{ t('Calling webhook url') }}</span>
                <span v-if="!loading">{{ t('Webhook finished') }}</span>
            </div>

            <kiss-card class="kiss-flex kiss-flex-middle kiss-padding kiss-margin" theme="contrast shadowed" gap="small">
                <span class="kiss-badge">{{ webhook.method }}</span>
                <div class="kiss-flex-1 kiss-size-small kiss-color-muted kiss-text-monospace kiss-text-truncate">{{ webhook.url }}</div>
            </kiss-card>

            <div class="kiss-padding-large" v-if="loading"><app-loader size="small"></app-loader></div>

            <kiss-card class="kiss-margin" v-if="!loading && result">

                <div class="kiss-flex kiss-flex-middle kiss-margin" gap>
                    <span class="kiss-badge kiss-badge-outline" :class="result.success ? 'kiss-color-success':'kiss-color-danger'">{{ result.success ? 'Success': 'Failed' }}</span>
                    <div class="kiss-flex-1 kiss-size-small kiss-color-muted">{{ result.status_line }}</div>
                    <div class="kiss-flex kiss-flex-middle kiss-size-small" gap="small">
                        <icon size="larger">timer</icon>
                        <div>{{duration}} seconds</div>
                    </div>
                </div>

                <kiss-tabs>

                    <tab class="kiss-margin animated fadeIn" caption="Payload">
                        <kiss-card class="kiss-padding kiss-text-monospace kiss-size-small" theme="contrast bordered" style="height: 250px;overflow: scroll;">{{result.content}}</kiss-card>
                    </tab>

                    <tab class="kiss-margin animated fadeIn" caption="Headers">
                        <kiss-card class="kiss-padding" theme="bordered" style="height: 250px;overflow: scroll;" v-if="result.headers && Object.keys(result.headers).length">
                            <table class="kiss-table">
                                <tbody>
                                    <tr v-for="(val, key) in result.headers">
                                        <td class="kiss-text-bold"><div class="kiss-size-xsmall kiss-text-monospace">{{key}}</div></td>
                                        <td class="kiss-color-muted"><div class="kiss-size-xsmall kiss-text-monospace">{{ JSON.stringify(val).replace(/"$/, '').replace(/^"/, '') }}</div></td>
                                    </tr>
                                </tbody>
                            </table>
                        </kiss-card>
                    </tab>

                    <tab class="kiss-margin animated fadeIn" caption="Curl">
                        <kiss-card class="kiss-padding kiss-size-small" theme="contrast bordered" style="height: 250px;overflow: scroll;">
                            <pre><code class="kiss-text-monospace"
                                style="
                                    word-wrap: break-word;
                                    white-space: pre-wrap;
                                    word-break: break-all;
                                "
                            >{{result.curl_command}}</code></pre>
                        </kiss-card>
                    </tab>

                </kiss-tabs>

            </div>

            <div class="kiss-flex kiss-margin" :class="{'kiss-disabled':loading}" gap>
                <div class="kiss-flex-1"></div>
                <button class="kiss-button" autofocus kiss-dialog-close>{{ t('Close') }}</button>
            </div>

        </div>
    `
}
