<kiss-container class="kiss-margin-small">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/pages')?>"><?=t('Site tree')?></a></li>
    </ul>

    <vue-view>

        <template>

            <form class="kiss-flex kiss-margin" :class="{'kiss-disabled': loading}" @submit.prevent="filter = txtFilter" gap="small">

                <input type="text" class="kiss-input kiss-flex-1 kiss-margin-xsmall-end" :placeholder="t('Filter pages...')" v-model="txtFilter">

                <div class="kiss-button-group">
                    <button type="button" class="kiss-button" @click="filter = ''" v-if="filter"><?=t('Reset')?></button>
                    <button class="kiss-button kiss-flex"><?=t('Search')?></button>
                </div>
            </form>

            <app-scrollcontainer mode="boundary-include" boundary="app-actionbar">

                <div class="animated fadeIn kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center kiss-color-muted" v-if="pages && !pages.length">
                    <div>
                        <kiss-svg :src="$baseUrl('pages:icon.svg')" width="40" height="40"><canvas width="40" height="40"></canvas></kiss-svg>
                        <p class="kiss-size-large kiss-margin-small-top"><?=t('No pages')?></p>
                    </div>
                </div>

                <div v-if="!loading && (filter || pageType) && Array.isArray(pages) && pages.length">

                    <div class="kiss-margin-small kiss-text-caption kiss-color-muted"><?=t('Filtered pages')?></div>

                    <div class="kiss-margin-xsmall" v-for="page in pages">
                        <kiss-card class="kiss-padding-small kiss-flex kiss-flex-middle kiss-margin-xsmall" theme="bordered contrast">
                            <div class="kiss-margin-small-end">
                                <icon :class="{'kiss-color-danger': !page._state, 'kiss-color-success': page._state === 1}" v-if="!page._state || locale == 'default'">circle</icon>
                                <icon class="kiss-color-danger" v-else-if="siteSettings.locales[locale] === false">cloud_off</icon>
                                <icon class="kiss-color-danger" v-else-if="page._locales && page._locales[locale] === false">circle</icon>
                                <icon :class="{'kiss-color-danger': !page._state, 'kiss-color-success': page._state === 1}" v-else>circle</icon>
                            </div>
                            <div class="kiss-flex-1 kiss-size-small kiss-text-truncate kiss-visible-toggle">

                                <a class="kiss-link-muted" :href="$routeUrl('/pages/page/'+page._id)" :class="{'kiss-text-bold': page._children}">
                                    {{ page.title }}
                                </a>

                                <span class="kiss-badge kiss-margin-small-start kiss-text-upper kiss-invisible-hover">{{ page.type }}</span>
                            </div>
                            <div class="kiss-size-xsmall kiss-text-truncate kiss-color-muted kiss-margin-start kiss-width-1-2 kiss-visible@m">{{ page._r }}</div>
                            <a class="kiss-margin-small-start" @click="createPage(page._id)"><icon>create_new_folder</icon></a>
                            <a class="kiss-margin-small-start kiss-color-danger" @click="remove(page)"><icon>delete</icon></a>
                        </kiss-card>
                    </div>
                </div>

                <div v-if="loading !== true && (!filter && !pageType) && Array.isArray(pages) && pages.length">

                    <kiss-row gap="large">
                        <div class="kiss-flex-1">
                            <div class="kiss-margin-small kiss-text-caption kiss-color-muted"><?=t('Pages')?></div>
                            <pages-tree v-model="pages" :locale="locale" :site-settings="siteSettings"></pages-tree>
                        </div>
                        <div class="kiss-width-1-3@m">
                            <div class="kiss-margin-small kiss-text-caption kiss-color-muted"><?=t('Recent updates')?></div>
                            <pages-recent :limit="10" :locale="locale"></pages-recent>
                        </div>
                    </kiss-row>
                </div>

                <app-loader v-if="loading === null || loading === true"></app-loader>
            </app-scrollcontainer>

            <teleport to="body">
                <app-actionbar space="false">
                    <kiss-container :class="{'kiss-disabled': loading}">
                        <div class="kiss-flex kiss-flex-middle">

                            <div v-if="Object.keys(App._locales).length > 1">
                                <span class="kiss-text-caption kiss-color-muted"><?=t('Locale')?></span>
                                <div class="kiss-margin-xsmall-top kiss-display-block kiss-overlay-input">
                                    <div class="kiss-size-4" :class="{'kiss-color-muted': locale == 'default', 'kiss-color-primary': locale != 'default'}">{{ App._locales[this.locale] }}</div>
                                    <select v-model="locale"><option :value="i18n" v-for="(label,i18n) in App._locales">{{label}}</option></select>
                                </div>
                            </div>

                            <div class="kiss-margin-start" v-if="Object.keys(pageTypes).length > 1">
                                <span class="kiss-text-caption kiss-color-muted"><?=t('Page Type')?></span>
                                <div class="kiss-margin-xsmall-top kiss-display-block kiss-overlay-input">
                                    <div class="kiss-size-4" :class="{'kiss-color-muted': !pageType, 'kiss-color-primary': pageType}">{{ pageType ? (pageTypes[pageType] ? (pageTypes[pageType].label || pageType) : pageType) : t('All types')  }}</div>
                                    <select v-model="pageType">
                                        <option value=""><?=t('All')?></option>
                                        <?php foreach ($pageTypes as $type => $meta): ?>
                                        <option value="<?=$type?>"><?=(isset($meta['label']) && $meta['label'] ? $meta['label'] : $type)?></option>
                                        <?php endforeach ?>
                                    </select>
                                </div>
                            </div>

                            <div class="kiss-flex-1"></div>

                            <?php if (count(array_keys($pageTypes)) == 1): ?>
                            <a class="kiss-button kiss-button-primary" href="<?=$this->route('/pages/page')?>?type=<?=array_keys($pageTypes)[0]?>">
                                <?=t('Create page')?>
                            </a>
                            <?php else: ?>
                                <button type="button" class="kiss-button kiss-button-primary" @click="createPage()"><?=t('Create page')?></button>
                            <?php endif ?>
                        </div>
                    </kiss-container>
                </app-actionbar>
            </teleport>

        </template>

        <script type="module">

            export default {

                data() {
                    return {
                        pages: null,
                        pageTypes: <?=json_encode($pageTypes)?>,
                        siteSettings: <?=json_encode($settings)?>,
                        loading: false,
                        filter: '',
                        txtFilter: '',
                        locale: 'default',
                        pageType: null
                    }
                },

                mounted() {
                    this.load();
                },

                components: {
                    'pages-tree': 'pages:assets/vue-components/pages-tree.js',
                    'pages-recent': 'pages:assets/vue-components/pages-recent.js',
                },

                watch: {
                    filter(val) {
                        this.txtFilter = val;

                        if (val || this.pageType) {
                            this.find();
                        } else {
                            this.load();
                        }
                    },
                    locale() {

                        if (this.pageType || this.filter) {
                            this.find();
                        } else {
                            this.load();
                        }
                    },
                    pageType() {

                        if (this.pageType || this.filter) {
                            this.find();
                        } else {
                            this.load();
                        }
                    }
                },

                methods: {

                    load(pid = null) {

                        this.loading = pid;

                        let params = {
                            _pid: {}
                        };

                        if (this.locale != 'default') {
                            params.locale = this.locale;
                        }

                        this.$request('/pages/load', params).then(pages => {
                            this.pages = pages;
                            this.loading = false;
                        }).catch(res => {
                            this.loading = false;
                            App.ui.notify(res.error || 'Loading failed!', 'error');
                        });
                    },

                    find() {

                        let options = {
                            filter: this.filter,
                            limit: 20
                        };

                        if (this.locale !== 'default') {
                            options.locale = this.locale;
                        }

                        if (this.pageType) {
                            options.pageType = this.pageType;
                        }

                        this.loading = true;

                        this.$request('/pages/utils/find', {options}).then(res => {

                            this.pages = res.items;
                            this.loading = false;
                        }).catch(res => {
                            this.loading = false;
                            App.ui.notify(res.error || 'Loading failed!', 'error');
                        });
                    },

                    createPage(pid = null) {
                        VueView.ui.offcanvas('pages:assets/dialogs/choose-pagetype.js', {parent: pid, pageTypes: this.pageTypes});
                    },

                    remove(page) {
                        App.ui.confirm('Are you sure?', () => {

                            this.$request('/pages/remove', {page}).then(res => {
                                this.pages.splice(this.pages.indexOf(page), 1);
                            }).catch(res => {
                                App.ui.notify(res.error || 'Page removing failed!', 'error');
                            });
                        });
                    },
                }
            }

        </script>

    </vue-view>

</kiss-container>
