export default {

    props: {

        limit: {
            type: Number,
            default: 4
        },


        locale: {
            type: String,
            default: null
        }
    },

    components: {
        'pages-recent': Vue.defineAsyncComponent(() =>
            App.utils.import('pages:assets/vue-components/pages-recent.js')
        )
    },

    template: /*html*/`
        <kiss-card>

            <div class="kiss-text-caption kiss-text-bold">{{ t('Pages') }}</div>
            <div class="kiss-color-muted kiss-size-small kiss-margin-xsmall">{{ t('Latest updated pages') }}</div>

            <pages-recent :locale="locale" :limit="limit"></pages-recent>

            <div class="kiss-margin-small">
                <a class="kiss-button kiss-button-small" :href="$routeUrl('/pages')">{{ t('Go to pages') }}</a>
            </div>

        </kiss-card>
    `
}
