function findObjectByPropValue(obj, prop, val) {
    if (typeof obj !== 'object' || obj === null) {
        return null;
    }

    if (obj.hasOwnProperty(prop) && obj[prop] === val) {
        return obj;
    }

    for (let key in obj) {
        if (obj.hasOwnProperty(key)) {
            let result = findObjectByPropValue(obj[key], prop, val);
            if (result) {
                return result;
            }
        }
    }

    return null;
}


export default {

    data() {

    },

    components: {
        pagesPage: Vue.defineAsyncComponent(() =>
            App.utils.import('pages:assets/storefront/admin/modules/pages/vue-components/page.js')
        ),
        pagesMenu: Vue.defineAsyncComponent(() =>
            App.utils.import('pages:assets/storefront/admin/modules/pages/vue-components/menu.js')
        ),
    },

    props: {
        page: {
            type: Array,
            default: []
        },
        menus: {
            type: Array,
            default: []
        },
        locale: {
            type: String,
            default: 'default'
        }
    },

    computed: {
        componentMap() {
            let map = {};

            if (Array.isArray(this.page)) {
                this.page.forEach(p => {
                    if (p.data && p.data.id) {
                        map[p.data.id] = p.spotId;
                    }
                });
            }

            return map;
        }
    },

    methods: {

        highlight(spotId) {
            this.$emit('storefront:highlight', { spotId });
        },

        edit(id, context) {

            context = context || 'page';

            switch (context) {
                case 'page':

                    let page = this.$refs.pages[0].data.page;

                    if (page.type !== 'layout') return;

                    let component = findObjectByPropValue(page.data, 'id', id);

                    if (!component) return;

                    App.utils.getlayoutComponents().then(components => {

                        if (!components[component.component]) return;

                        VueView.ui.modal('layout:assets/vue-components/layout/component-edit.js', { component, mode: 'edit', globalComponents: components }, {

                            save: updatedComponent => {

                                Object.assign(component, updatedComponent);

                                App.request('/pages/save', { page }).then(page => {

                                    this.$emit('storefront:refresh', page);

                                }).catch(res => {
                                    App.ui.notify(res.error || 'Saving failed!', 'error');
                                });
                            }

                        }, { size: components[component.component].opts?.['dialog.size'] || 'large' })
                    });

                    break;
            }

        }
    },

    template: /*html*/`
        <div>

            <div class="kiss-size-4 kiss-text-bold kiss-flex kiss-flex-middle kiss-margin">
                <kiss-svg class="kiss-margin-small-end" :src="$baseUrl('pages:icon.svg')" width="30" height="30"><canvas width="30" height="30"></canvas></kiss-svg>
                {{ t('Pages') }}
            </div>

            <div class="kiss-margin" v-if="Array.isArray(page) && page.length">
                <div class="kiss-text-caption kiss-color-muted kiss-margin-small-bottom">{{ t('Page') }}</div>
                <pages-page v-for="p in page" :page="p" :key="p._id" :locale="locale" :component-map="componentMap" @highlight="highlight" ref="pages"></pages-page>
            </div>

            <div class="kiss-margin" v-if="Array.isArray(menus) && menus.length">
                <div class="kiss-text-caption kiss-color-muted">{{ t('Menus') }}</div>
                <pages-menu class="kiss-margin-small" v-for="menu in menus" :menu="menu"></pages-menu>
            </div>
        </div>
    `
}
