export default {

    data() {
        return {
            data: null
        }
    },

    props: {
        menu: {
            type: String,
            default: null
        }
    },

    mounted() {
        this.load();
    },

    methods: {
        load() {

            this.$request(`/pages/menus/menu/${this.menu}/true`).then((data) => {
                this.data = data;
            }).catch((err) => {
                console.error(err);
            });
        }
    },

    template: /*html*/`
        <kiss-card>
            <app-loader size="small" mode="dots" v-if="!data"></app-loader>
            <div class="kiss-size-small kiss-flex kiss-flex-middle kiss-visible-toggle" gap="small" v-if="data">
                <kiss-svg :src="$baseUrl('pages:assets/icons/nav.svg')" width="20" height="20" :style="{color:data.menu.color}"><canvas width="20" height="20"></canvas></kiss-svg>
                <div class="kiss-text-truncate kiss-flex-1">{{ data.menu.label || data.menu.name  }}</div>
                <a class="animated fadeInRight faster kiss-hidden-hover" :href="$routeUrl('/pages/menus/menu/'+data.menu.name)" target="_blank"><icon>edit</icon></a>
            </div>
        </kiss-card>
    `
}
