<?php

namespace Pages\Controller;

use App\Controller\App;

class Controller extends App {

    protected function before() {

        if (!$this->isAllowed('pages/manage')) {
            return $this->stop(403);
        }

        $this->helper('theme')->favicon('pages:icon.svg');
    }

    protected function render(string $view, array $params = []): mixed {

        $contents = $this->app->render($view, $params);

        $view = 'pages:layouts/layout.php';
        $view .= $this->layout ? " with ".$this->layout:"";

        return $this->app->render($view, \compact('contents'));
    }

}
