<?php

// load admin related code
$this->on('app.admin.init', function() {
    include(__DIR__.'/admin.php');
});

// load api request related code
$this->on('app.api.request', function() {
    include(__DIR__.'/api.php');
});


// lokalize api
$this->module('lokalize')->extend([

    // memoize data
    '_projects' => [],

    'projects' => function(array $options = []) {

        $options = array_merge([
            'sort' => ['name' => 1]
        ], $options);

        $projects = $this->app->dataStorage->find('lokalize/projects', $options)->toArray();

        return $projects;
    },

    'project' => function(string $name) {

        $project = $this->app->dataStorage->findOne('lokalize/projects', ['name' => $name]);

        return $project;
    },

    'saveProject' => function(array $project) {

        $this->app->trigger('lokalize.project.save.before', [&$project]);

        if (!isset($project['_id']) && isset($project['locales']) && count($project['locales'])) {

            foreach ($project['locales'] as $locale) {
                $project['status'][$locale['i18n']] = 0;
            }
        }

        $this->app->dataStorage->save('lokalize/projects', $project);

        $this->app->trigger('lokalize.project.save', [$project]);

        return $project;
    },

    'value' => function(string $projectName, string $key, ?string $locale = null) {

        // chack for cached project
        if (!isset($this->props['_projects'][$projectName])) {

            $project = $this->project($projectName);

            if (!$project) {
                $this->props['_projects'][$projectName] = false;
                return null;
            }

            $values = new \ArrayObject(isset($project['values']) ? $project['values'] : []);

            foreach ($project['locales'] as $_locale) {

                if (!isset($values[$_locale['i18n']]))  {
                    $values[$_locale['i18n']] = new \ArrayObject([]);
                }
            }

            $project['values'] = $values;

            // cache project for further calls
            $this->props['_projects'][$projectName] = $project;
        }

        $project = $this->props['_projects'][$projectName];

        if (!$project) {
            return null;
        }

        if ($locale && !isset($project['values'][$locale])) {
            return null;
        }

        if ($locale) {
            return $project['values'][$locale][$key]['value'] ?? null;
        }

        $values = [];

        foreach ($project['locales'] as $_locale) {
            $values[$_locale['i18n']] = $project['values'][$_locale['i18n']][$key]['value'] ?? null;
        }

        return $values;
    },

    'translate' => function(string $text, string $to, $context = null) {

        if (!trim($text) || !trim($to)) {
            return '';
        }

        if (!isset($this->props['_translator'])) {

            $config = $this->app->retrieve('lokalize/translation', []);
            $translator = $config['service'] ?? null;

            $this->props['_translator'] = match($translator) {
                'deepl' => new Lokalize\Translators\Deepl($config),
                'libretranslate' => new Lokalize\Translators\LibreTranslate($config),
                'autopilot' => new Lokalize\Translators\Autopilot(array_merge($config, ['app' => $this->app])),
                default => null
            };
        }

        if ($this->props['_translator']) {
            return $this->props['_translator']->translate($text, $to, $context);
        }

        return '';

    }

]);
