export default {
    data() {

        const locales = {
                "sq": "Albanian",
                "ar": "Arabic",
                "az": "Azerbaijani",
                "eu": "Basque",
                "bn": "Bengali",
                "bg": "Bulgarian",
                "ca": "Catalan",
                "zh": "Chinese",
                "zt": "Chinese (traditional)",
                "cs": "Czech",
                "da": "Danish",
                "nl": "Dutch",
                "en": "English",
                "eo": "Esperanto",
                "et": "Estonian",
                "fi": "Finnish",
                "fr": "French",
                "gl": "Galician",
                "de": "German",
                "el": "Greek",
                "he": "Hebrew",
                "hi": "Hindi",
                "hu": "Hungarian",
                "id": "Indonesian",
                "ga": "Irish",
                "it": "Italian",
                "ja": "Japanese",
                "ko": "Korean",
                "lv": "Latvian",
                "lt": "Lithuanian",
                "ms": "Malay",
                "nb": "Norwegian",
                "fa": "Persian",
                "pl": "Polish",
                "pt": "Portuguese",
                "ro": "Romanian",
                "ru": "Russian",
                "sr": "Serbian",
                "sk": "Slovak",
                "sl": "Slovenian",
                "es": "Spanish",
                "sv": "Swedish",
                "tl": "Tagalog",
                "th": "Thai",
                "tr": "Turkish",
                "uk": "Ukrainian",
                "ur": "Urdu",
                "vi": "Vietnamese"
            };

        return {
            selected: locales[this.locale] ? this.locale : 'en',
            locales,
        }
    },

    props: {
        locale: {
            type: String,
            default: null
        }
    },

    methods: {
        select() {
            this.$call('onSelect', this.selected);
            this.$close();
        }
    },

    template: /*html*/`
        <div>
            <div class="kiss-flex kiss-flex-middle kiss-margin">
                <div>
                    <kiss-svg class="kiss-color-primary" :src="$baseUrl('lokalize:icon.svg')" width="35" height="50"></kiss-svg>
                </div>
                <div class="kiss-flex-1 kiss-margin-start">
                    <span class="kiss-size-xsmall kiss-color-muted kiss-text-upper">Lokalize</span>
                    <kiss-row class="kiss-flex-middle">
                        <div class="kiss-size-4 kiss-flex-1">
                            <span class="kiss-text-capitalize">{{ t('Text Translation') }}</span>
                        </div>
                    </kiss-row>
                </div>
                <button type="button" :aria-label="t('Close')" class="kiss-input-blank kiss-cursor-pointer" kiss-dialog-close>
                    <kiss-svg class="kiss-color-muted" :src="$baseUrl('system:assets/icons/close.svg')" width="15"><canvas width="15" height="15"></canvas></kiss-svg>
                </button>
            </div>

            <div class="kiss-margin-large">
                <label class="kiss-text-caption">{{ t('Target language') }}</label>
                <select class="kiss-input kiss-margin-xsmall-top" v-model="selected">
                    <option v-for="(name, i18n) in locales" :value="i18n">{{ name }}</option>
                </select>
            </div>

            <div class="kiss-margin-top kiss-flex kiss-flex-middle kiss-button-group">
                <button type="button" class="kiss-button-cancel kiss-button kiss-flex-1" kiss-dialog-close>{{ t('Cancel') }}</button>
                <button type="button" class="kiss-button-confirm kiss-button kiss-button-primary kiss-flex-1" @click="select">{{ t('Translate') }}</button>
            </div>

        </div>
    `
}
