<kiss-container class="kiss-margin" size="small">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/system')?>"><?=t('Settings')?></a></li>
        <li><a href="<?=$this->route('/layout-components/templates')?>"><?=t('Templates')?></a></li>
    </ul>

    <vue-view>
        <template>

            <div class="kiss-margin-large-bottom kiss-size-3 kiss-text-bold">
                <span v-if="!template._id"><?=t('Create template')?></span>
                <span v-if="template._id"><?=t('Edit template')?></span>
            </div>

            <form :class="{'kiss-disabled':saving}" @submit.prevent="save">

                <div class="kiss-margin">
                    <label><?=t('Name')?></label>
                    <input class="kiss-input" type="text" v-model="template.name" required>
                </div>

                <div class="kiss-margin-large app-fieldcontainer-no-style">
                    <div class="kiss-text-caption kiss-color-muted kiss-margin"><?=t('Layout')?></div>
                    <field-layout v-model="template.layout"></field-layout>
                </div>

                <app-actionbar>

                    <kiss-container size="small">
                        <div class="kiss-flex kiss-flex-middle kiss-flex-end">
                            <div class="kiss-button-group">
                                <a class="kiss-button" href="<?=$this->route('/layout-components/templates')?>">
                                    <span v-if="!template._id"><?=t('Cancel')?></span>
                                    <span v-if="template._id"><?=t('Close')?></span>
                                </a>
                                <button type="submit" class="kiss-button kiss-button-primary">
                                    <span v-if="!template._id"><?=t('Create template')?></span>
                                    <span v-if="template._id"><?=t('Update template')?></span>
                                </button>
                            </div>
                        </div>
                    </kiss-container>

                </app-actionbar>

            </form>

        </template>

        <script type="module">

            export default {

                data() {

                    return {
                        saving: false,
                        template: <?=json_encode($template)?>,
                    };
                },

                methods: {

                    save() {

                        let isUpdate = this.template._id;

                        this.saving = true;

                        this.$request('/layout-components/templates/save', {template: this.template}).then(template => {

                            this.template = template;
                            this.saving = false;

                            if (isUpdate) {
                                App.ui.notify('Template updated!');
                            } else {
                                App.ui.notify('Template created!');
                            }
                        }).catch(res => {
                            this.saving = false;
                            App.ui.notify(res.error || 'Saving failed!', 'error');
                        });

                    }
                }
            }
        </script>

    </vue-view>

</kiss-container>
