<?php

$meta = new ArrayObject($meta ?? []);
$component['data'] = new ArrayObject($component['data'] ?? []);

$locales = $this->helper('locales')->locales();

if (count($locales) == 1) {
    $locales = [];
} else {
    $locales[0]['visible'] = true;
}

?>
<kiss-container class="kiss-margin" size="medium">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/system')?>"><?=t('Settings')?></a></li>
        <li><a href="<?=$this->route('/layout-components/shared')?>"><?=t('Shared components')?></a></li>
    </ul>

    <vue-view>
        <template>

            <div class="kiss-margin-large-bottom kiss-size-3 kiss-text-bold">
                <span v-if="!component._id"><?=t('Create component')?></span>
                <span v-if="component._id"><?=t('Edit component')?></span>
            </div>

            <kiss-row gap="large">

                <form class="kiss-flex-1" :class="{'kiss-disabled':saving}" @submit.prevent="save">

                    <div class="kiss-margin">
                        <label><?=t('Name')?></label>
                        <input class="kiss-input" type="text" v-model="component.name" required>
                    </div>

                    <div class="kiss-margin-large app-fieldcontainer-no-style">

                        <div class="kiss-text-caption kiss-text-bold"><?=t('Component Data')?></div>

                        <div class="kiss-margin">
                            <fields-renderer :fields="meta.fields" v-model="component.data" :locales="component.i18n ? locales : []"></fields-renderer>
                        </div>

                        <div class="kiss-margin" v-if="meta.children">
                            <fields-renderer v-model="component" :fields="[{name:'children', type:'layout', i18n:true}]" :locales="component.i18n ? locales : []"></fields-renderer>
                        </div>

                        </div>
                    </div>

                    <app-actionbar>

                        <kiss-container size="small">
                            <div class="kiss-flex kiss-flex-middle kiss-flex-end">
                                <div class="kiss-button-group">
                                    <a class="kiss-button" href="<?=$this->route('/layout-components/shared')?>">
                                        <span v-if="!component._id"><?=t('Cancel')?></span>
                                        <span v-if="component._id"><?=t('Close')?></span>
                                    </a>
                                    <button type="submit" class="kiss-button kiss-button-primary">
                                        <span v-if="!component._id"><?=t('Create component')?></span>
                                        <span v-if="component._id"><?=t('Update component')?></span>
                                    </button>
                                </div>
                            </div>
                        </kiss-container>

                    </app-actionbar>

                </form>
                <div class="kiss-width-1-4@m">

                    <div class="kiss-margin" v-if="hasLocales">
                        <field-boolean v-model="component.i18n" :label="t('Translation enabled')"></field-boolean>
                    </div>

                    <div class="kiss-margin" v-if="component.i18n">

                        <div class="kiss-text-caption kiss-size-xsmall kiss-text-bold">{{ t('Translation') }}</div>

                        <kiss-card class="kiss-padding-small kiss-margin-small kiss-text-muted kiss-size-small kiss-color-muted kiss-flex kiss-flex-middle" theme="bordered" v-if="!locales.length">
                            <span class="kiss-flex-1 kiss-margin-small-end">{{ t('No locales.') }}</span>
                            <a class="kiss-size-xsmall  kiss-text-bolder" href="<?=$this->route('/system/locales')?>">{{ t('Manage') }}</a>
                        </kiss-card>

                        <div class="kiss-margin-small" v-if="locales.length">

                            <kiss-card class="kiss-position-relative kiss-padding-small kiss-margin-small kiss-text-bolder kiss-flex kiss-flex-middle" :class="{'kiss-color-muted': !loc.visible}" :theme="!loc.visible ? 'bordered':'bordered contrast'" v-for="loc in locales">
                                <icon class="kiss-margin-small-end" :class="{'kiss-color-primary': loc.visible}">{{ loc.visible ? 'visibility' : 'visibility_off' }}</icon>
                                <span class="kiss-size-small kiss-flex-1">{{ loc.name }}</span>
                                <span class="kiss-color-muted kiss-size-xsmall" v-if="loc.i18n == 'default'">{{ t('Default') }}</span>
                                <a class="kiss-cover" @click="loc.visible = !loc.visible"></a>
                            </kiss-card>
                        </div>

                    </div>
                </div>
            </kiss-row>

        </template>

        <script type="module">

            export default {

                data() {

                    return {
                        saving: false,
                        locales: <?=json_encode($locales)?>,
                        meta: <?=json_encode($meta)?>,
                        component: <?=json_encode($component)?>,
                    };
                },

                computed: {

                    hasLocales() {

                        if (this.meta.children) {
                            return true;
                        }

                        for (let i=0;i < this.meta.fields.length;i++) {
                            if (this.meta.fields[i].i18n) return true;
                        }
                        return false;
                    }
                },

                methods: {

                    save() {

                        let validate = {root: this.$el};

                        App.trigger('fields-renderer-validate', validate);

                        if (validate.errors) {
                            return;
                        }

                        let isUpdate = this.component._id;

                        this.saving = true;

                        this.$request('/layout-components/shared/save', {component: this.component}).then(component => {

                            this.component = component;
                            this.saving = false;

                            if (isUpdate) {
                                App.ui.notify('Component updated!');
                            } else {
                                App.ui.notify('Component created!');
                            }
                        }).catch(res => {
                            this.saving = false;
                            App.ui.notify(res.error || 'Saving failed!', 'error');
                        });

                    }
                }
            }
        </script>

    </vue-view>

</kiss-container>
