import {getGroupColor} from './utils.js';

export default {

    data() {

        let meta = this.globalComponents[this.component.component];
        let item = JSON.parse(JSON.stringify(this.component));

        return {
            meta,
            item,
            getGroupColor
        }
    },

    props: {
        component: {
            type: Object,
            default: null
        },
        globalComponents: {
            type: Object,
            default: null
        },
        mode: {
            type: String,
            default: 'edit'
        }
    },

    methods: {
        save() {

            let validate = {root: this.$el};

            App.trigger('fields-renderer-validate', validate);

            if (validate.errors) {
                return;
            }

            this.$call('save', this.item);
            this.$close();
        }
    },

    template: /*html*/`
        <div>

            <div class="kiss-flex kiss-flex-middle kiss-margin-bottom">
                <div>
                    <kiss-svg :src="$baseUrl(meta.icon)" width="45" height="45" :style="{color: getGroupColor(meta.group)}" v-if="meta.icon"></kiss-svg>
                    <app-avatar size="45" :name="item.component" :color="getGroupColor(meta.group)" v-if="!meta.icon"></app-avatar>
                </div>
                <div class="kiss-flex-1 kiss-margin-start">
                    <span class="kiss-size-xsmall kiss-color-muted kiss-text-upper">{{ item.component }}</span>
                    <kiss-row class="kiss-flex-middle">
                        <div class="kiss-size-4 kiss-text-bold kiss-flex-1">{{ mode=='add' ? t('Add component') : t('Edit component') }}</div>
                        <div><field-boolean v-model="item.hidden" :label="t('Hide component')"></field-boolean></div>
                    </kiss-row>
                </div>
            </div>

            <input class="kiss-input" type="text" v-model="item.label">

            <div class="kiss-margin kiss-dialog-overflow">
                <kiss-tabs>
                    <tab class="animated fast fadeIn" :caption="t('Data')" v-if="meta.fields && meta.fields.length">
                        <fields-renderer v-model="item.data" :fields="meta.fields"></fields-renderer>
                    </tab>
                    <tab class="animated fast fadeIn" :caption="t('Meta')">
                        <field-object v-model="item.meta"></field-object>
                    </tab>
                </kiss-tabs>
            </div>

            <div class="kiss-margin-top kiss-flex kiss-flex-middle kiss-button-group">
                <button type="button" class="kiss-button kiss-flex-1" @click="$close()">{{ t('Cancel') }}</button>
                <button type="button" class="kiss-button kiss-button-primary kiss-flex-1" @click="save">{{ t('Save') }}</button>
            </div>
        </div>
    `

}
