customElements.define('display-component', class extends HTMLElement {

    static get observedAttributes() {
        return ['component'];
    }

    constructor() {
        super();
    }

    connectedCallback() {

        this.ready = false;

        setTimeout(() => {
            this.render();
            this.ready = true;
        }, 0);
    }

    attributeChangedCallback(name, oldValue, newValue) {
        if (this.ready && oldValue !== newValue) this.render();
    }

    render() {

        let component = null;

        try {
            component = JSON.parse(this.getAttribute('component') || '{}');
        } catch (e) {
            this.innerHTML = 'n/a'
            return;
        }

        App.utils.getlayoutComponents().then(components => {

            let def = {

                data() {
                    return {
                        data: {
                            component,
                            components
                        }
                    }
                },

                components: {

                    vueDisplayComponent: {

                        props: ['component', 'components'],
                        components: {
                            componentPreview: Vue.defineAsyncComponent(() =>
                                App.utils.import(`layout:assets/vue-components/layout/component-preview.js?v=${App.version}`)
                            ),
                        },
                        computed: {
                            hasPreview() {
                                if (
                                    this.components[this.component.component] &&
                                    (
                                        // template preview
                                        this.components[this.component.component].preview ||
                                        //component preview Url
                                        (
                                            this.components[this.component.component].opts &&
                                            this.components[this.component.component].opts.previewComponent
                                        )
                                    )
                                ) {
                                    return true;
                                }

                                return false;
                            },
                        },
                        template: /*html*/`
                            <div>
                                <div class="kiss-margin-small kiss-text-caption"><span class="kiss-color-muted">{{ t('Component') }}:</span> <strong>{{ components[component.component].label || component.component }}</strong></div>
                                <component-preview :component="component" :globalComponents="components" v-if="hasPreview"></component-preview>
                            </div>
                        `
                    },
                },
            };

            this.innerHTML = /*html*/`
                <div class="display-content-preview">
                    <vue-display-component v-bind="data"></vue-display-component>
                </div>
            `;

            VueView.compile(this.querySelector('.display-content-preview'), def);
        });
    }

});
