<?php

    $types = $this->module('detektivo')->indexTypes();

?><kiss-container class="kiss-margin">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/detektivo')?>"><?=t('Detektivo')?></a></li>
    </ul>

    <div class="kiss-margin-large-bottom kiss-size-4 kiss-text-bold">
        <?=t('Indexes')?>
    </div>

    <vue-view>
        <template>

            <app-loader v-if="loading === true"></app-loader>

            <div v-if="indexes && indexes.length">

                <div class="kiss-margin">
                    <input type="text" class="kiss-input" :placeholder="t('Filter indexes...')" v-model="filter">
                </div>

                <kiss-card class="kiss-margin-small kiss-flex kiss-flex-middle animated fadeIn" theme="shadowed contrast" hover="shadow bordered-primary" gap="small" v-for="index in filtered">
                    <div class="kiss-position-relative kiss-padding-small kiss-bgcolor-contrast">
                        <canvas width="40" height="40"></canvas>
                        <div class="kiss-cover kiss-flex kiss-flex-middle kiss-flex-center">
                            <div :style="{color: index.color || 'inherit' }"><kiss-svg :src="getTypeIcon(index.type)" width="30" height="30"></kiss-svg></div>
                        </div>
                        <a class="kiss-cover" :href="$routeUrl(`/detektivo/idx/${index.name}`)"></a>
                    </div>
                    <div class="kiss-padding-small">
                        <a class="kiss-text-bold kiss-link-muted" :href="$routeUrl(`/detektivo/idx/${index.name}`)" :aria-label="index.name" kiss-tooltip="right">{{ index.label || index.name}}</a>
                    </div>
                    <div class="kiss-flex-1"></div>
                    <div class="kiss-padding-small kiss-size-small kiss-align-right kiss-color-muted kiss-visible@l">{{ index.info }}</div>
                    <div class="kiss-padding-small">
                        <a @click="toggleIndexActions(index)"><icon>more_horiz</icon></a>
                    </div>
                </kiss-card>

            </div>

            <div class="animated fadeIn kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center kiss-color-muted" v-if="!loading && indexes && (!indexes.length || !filtered.length)">
                <div>
                    <kiss-svg :src="$baseUrl('detektivo:assets/icons/index.svg')" width="40" height="40"><canvas width="40" height="40"></canvas></kiss-svg>
                    <p class="kiss-size-large kiss-margin-small-top"><?=t('No indexes')?></p>
                </div>
            </div>


            <teleport to="body">
                <app-actionbar>
                    <kiss-container :class="{'kiss-disabled': loading}">
                        <div class="kiss-flex kiss-flex-middle">

                            <div class="kiss-flex-1"></div>

                            <a class="kiss-button kiss-button-primary" href="<?=$this->route('/detektivo/create')?>"><?=t('Create index')?></a>
                        </div>
                    </kiss-container>
                </app-actionbar>

                <kiss-popout :open="actionIndex && 'true'" @popoutclose="toggleIndexActions(null)">
                    <kiss-content>
                            <kiss-navlist v-if="actionIndex">
                                <ul>
                                    <li class="kiss-nav-header">{{ actionIndex.label || actionIndex.name }}</li>
                                    <li>
                                        <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/detektivo/idx/${actionIndex.name}`)">
                                            <icon class="kiss-margin-small-end">visibility</icon>
                                            <?=t('Show')?>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="kiss-flex kiss-flex-middle" :href="$routeUrl(`/detektivo/index/${actionIndex.name}`)">
                                            <icon class="kiss-margin-small-end">edit</icon>
                                            <?=t('Edit')?>
                                        </a>
                                    </li>
                                    <li class="kiss-nav-divider"></li>
                                    <li>
                                        <a class="kiss-color-danger kiss-flex kiss-flex-middle" @click="remove(actionIndex)">
                                            <icon class="kiss-margin-small-end">delete</icon>
                                            <?=t('Delete')?>
                                        </a>
                                    </li>
                                </ul>
                            </kiss-navlist>
                    </kiss-content>
                </kiss-popout>

            </teleport>

        </template>

        <script type="module">

            export default {

                data() {
                    return {
                        types: <?=json_encode($types)?>,
                        indexes: [],
                        loading: true,
                        filter: '',
                        actionIndex: null
                    }
                },

                created() {
                    this.load();
                },

                computed: {

                    filtered() {

                        let indexes = [];

                        (this.indexes || []).forEach(idx => {

                            if (this.filter && !`${idx.name} ${idx.label || ''}`.toLocaleLowerCase().includes(this.filter.toLocaleLowerCase())) {
                                return;
                            }

                            indexes.push(idx)
                        });

                        return indexes;
                    },
                },


                methods: {

                    getTypeIcon(typeName) {
                        return this.$baseUrl(this.types[typeName].icon || 'detektivo:assets/icons/index.svg');
                    },

                    load() {

                        this.loading = true;

                        this.$request('/detektivo/load').then(indexes => {

                            this.loading = false;
                            this.indexes = indexes;
                        });
                    },

                    remove(index) {

                        App.ui.confirm('Are you sure?', () => {

                            this.$request(`/detektivo/remove/${index.name}`).then(res => {
                                this.indexes.splice(this.indexes.indexOf(index), 1);
                                App.ui.notify('Index removed!');
                            });
                        });
                    },

                    toggleIndexActions(index) {

                        if (!index) {
                            setTimeout(() => this.actionIndex = null, 300);
                            return;
                        }

                        this.actionIndex = index;
                    }

                }

            }
        </script>

    </vue-view>

</kiss-container>
