<div class="kiss-margin-small">
    <?=$contents?>
</div>

<?php $this->start('app-side-panel') ?>

<kiss-card>

    <h2 class="kiss-size-4"><?=t('Detektivo')?></h2>

    <kiss-navlist>
        <ul>
            <li>
                <a class="kiss-flex kiss-flex-middle <?=($this->request->route === '/detektivo' ? 'kiss-link-muted kiss-text-bold':'kiss-color-muted')?>" href="<?=$this->route('/detektivo')?>">
                    <kiss-svg class="kiss-margin-small-end" src="<?=$this->base('detektivo:icon.svg')?>" width="20" height="20"><canvas width="20" height="20"></canvas></kiss-svg>
                    <?=t('Overview')?>
                </a>
            </li>
        </ul>
    </kiss-navlist>

    <vue-view class="kiss-margin">
        <template>

            <kiss-navlist>
                <ul>
                    <li class="kiss-nav-header kiss-margin-top kiss-margin-xsmall-bottom"><?=t('Indexes')?></li>
                    <li v-for="index in processed">
                        <a class="kiss-flex kiss-flex-middle" gap="small" :class="index.isActive ? 'kiss-link-muted kiss-text-bold':'kiss-color-muted'" :href="$routeUrl(`/detektivo/idx/${index.name}`)">
                            <div :style="{color: index.isActive && index.color || 'inherit' }"><kiss-svg src="<?=$this->base('detektivo:assets/icons/index.svg')?>" width="20" height="20"><canvas width="20" height="20"></canvas></kiss-svg></div>
                            <div class="kiss-flex-1 kiss-text-truncate">{{ index.label || index.name }}</div>
                        </a>
                    </li>
                </ul>
            </kiss-navlist>

            <app-loader class="kiss-display-inline-block" size="small" mode="dots" v-if="loading"></app-loader>

            <kiss-card class="kiss-color-muted kiss-size-small kiss-margin-small" v-if="!loading && indexes && !indexes.length">
                <?=t('No index created yet')?>
            </kiss-card>

            <a class="kiss-button kiss-button-small kiss-margin" href="<?=$this->route('/detektivo/create')?>" v-if="!loading"><?=t('Create index')?></a>

        </template>

        <script type="module">

            export default {

                data() {
                    return {
                        indexes: [],
                        loading: true
                    }
                },

                created() {

                    this.load();

                    AppEventStream.on('detektivo.indexes.updated', () => {
                        this.load();
                    });
                },

                computed: {
                    processed() {

                        this.indexes.forEach(index => {
                            index.isActive = '<?=$this->request->route?>'.match(`/detektivo/idx/${index.name}`)
                        });

                        return this.indexes;
                    }
                },

                methods: {

                    load() {

                        this.loading = true;

                        this.$request('/detektivo/load').then(indexes => {

                            this.loading = false;
                            this.indexes = indexes;
                        });
                    }

                }

            }
        </script>

    </vue-view>

</kiss-card>

<?php $this->end('app-side-panel') ?>
