<?php

namespace Detektivo\Controller;

use App\Controller\App;

class Controller extends App {


    protected function before() {

        if (!$this->isAllowed('detektivo/manage')) {
            return $this->stop(401);
        }

        $this->helper('theme')->favicon('detektivo:icon.svg');
    }

    protected function render(string $view, array $params = []): mixed {

        $contents = $this->app->render($view, $params);

        $view = 'detektivo:layouts/layout.php';
        $view .= $this->layout ? " with ".$this->layout:"";

        return $this->app->render($view, \compact('contents'));
    }

}
