const actions = {

    prompt: {
        label: 'Prompt',
        icon: 'chat',
        handler(root) {

            VueView.ui.modal('autopilot:assets/dialogs/prompt.js', {
                fields: Object.keys(root.document).filter(field => field[0] !== '_'),
                root: root,
                handler(prompt, messageClb) {

                    if (!prompt.trim()) return;

                    let message = [
                        'CONTEXT: You are working within a Cockpit CMS content management system.',
                        'The following JSON contains field data from the current content item:',
                        JSON.stringify(root.document, null, 2),
                        '',
                        'INSTRUCTIONS:',
                        '- You are an expert content creator working within Cockpit CMS',
                        '- Generate high-quality, engaging HTML content that fits the context and purpose',
                        '- Reference field values when relevant to the user\'s request',
                        '- Maintain consistency with existing content tone and style',
                        '- Consider SEO best practices and user engagement when applicable',
                        '- Use semantic HTML markup and ensure accessibility',
                        '- Return only the HTML content without explanations or meta-commentary',
                        '',
                        'User input:',
                        prompt
                    ].join("\n");

                    root.execute([{
                        role: 'user',
                        content: message
                    }], (msg) => {
                        messageClb(msg);
                        //root.updateValue(msg);
                    });
                }
            }, {}, {
                size: 'large',
                escape: true
            });

        }
    },

    translate: {
        label: 'Translate',
        handler(root) {

            if (!root.val || !root.val.trim()) {
                return;
            }

            let to = '';

            if (root.field.i18n && root.locale && root.locale !== 'default') {
                to = root.locale;
            }

            App.ui.prompt('Translate to', to, (locale) => {

                if (!locale.trim()) return;

                let message = [
                    'You are an expert translator with native-level fluency in multiple languages.',
                    'Translate the following HTML content while preserving all HTML markup and structure.',
                    'Return only the translated HTML without any explanations, notes, or additional information.',
                    'Ensure the translation:',
                    '- Preserves the original meaning completely',
                    '- Uses natural phrasing as a native speaker would use',
                    '- Maintains the same tone and style as the original',
                    '- Adapts idioms and expressions appropriately for the target language',
                    '- Considers cultural context and local usage patterns',
                    '- Keeps all HTML tags, attributes, and structure intact',
                    '',
                    `Target Language: ${locale}`,
                    '',
                    'HTML content for translation:',
                    root.val
                ].join("\n");

                root.execute([{
                    role: 'user',
                    content: message
                }], (msg) => {
                    root.updateValue(msg);
                });
            });
        }
    },

    shorten: {
        label: 'Shorten',
        handler(root) {

            if (!root.val || !root.val.trim()) {
                return;
            }

            App.ui.prompt('Max length', root.val.length, (maxlength) => {

                if (!maxlength || !(!isNaN(parseFloat(maxlength)) && isFinite(maxlength)) || root.val.length <= maxlength) {
                    return;
                }

                let message = [
                    'Shorten the following HTML content while preserving the core message and key information.',
                    `Target length: maximum ${maxlength} characters.`,
                    'Prioritize clarity and maintain the original tone.',
                    'Remove redundancy but keep essential details.',
                    'Preserve all necessary HTML markup and structure.',
                    'Return only the shortened HTML content without explanations.',
                    '',
                    'Original HTML content:',
                    root.val
                ].join("\n");

                root.execute([{
                    role: 'user',
                    content: message
                }], (msg) => {
                    root.updateValue(msg);
                });
            });

        }
    }
}

export default {

    init() {
        return new Promise((resolve, reject) => {
            resolve(actions);
        });
    },
}
