export default {

    _meta: {
        size: 'large',
        escape: true
    },

    data() {
        return {
            image: null,
            loading: false,

            prompt: '',
            quality: 'standard',

            style: 'vivid',
            styles: [
                'natural',
                'vivid',
            ],

            size: '1024x1024',
            sizes: [
                '1024x1024',
                '1024x1792',
                '1792x1024'
            ]
        }
    },

    props: {
        fields: {
            type: Array,
            default: []
        },
    },

    computed: {

    },

    methods: {

        send(e) {

            if (e) {
                e.preventDefault();
            }

            if (!this.prompt.trim()) {
                return;
            }

            App.ui.block(App.i18n.get('Generating image'));

            this.$request('/autopilot/image', {
                prompt: this.prompt,
                size: this.size,
                style: this.style,
            }).then(rsp => {

                if (!rsp || !rsp.url) {
                    return;
                }

                this.image = rsp.url;

            }).catch(rsp => {

                if (typeof(rsp) === 'string') {

                    try {
                        rsp = JSON.parse(rsp);
                    } catch (e) {}
                }

                App.ui.notify(rsp.error || 'Something went wrong', 'error');

                console.error(rsp)
            }).finally(() => {
                App.ui.unblock();
                this.loading = false;
            });
        },

        chooseImage() {
            this.$call('onChooseImage', this.image);
            this.$close();
        }
    },

    template: /*html*/`
        <div class="kiss-position-relative">

            <div class="kiss-flex kiss-flex-middle kiss-margin" gap="small">
                <div>
                    <kiss-svg class="kiss-color-primary" :src="$baseUrl('autopilot:icon.svg')" width="50" height="50"></kiss-svg>
                </div>
                <div class="kiss-flex-1">
                    <span class="kiss-size-xsmall kiss-color-muted kiss-text-upper">Autopilot</span>
                    <kiss-row class="kiss-flex-middle">
                        <div class="kiss-size-4 kiss-flex-1">
                            <span class="kiss-text-capitalize">{{ t('Image Generation') }}</span>
                        </div>
                    </kiss-row>
                </div>
                <kiss-card class="kiss-padding-small kiss-overlay-input kiss-width-1-5@m" theme="bordered">
                    <div class="kiss-text-caption kiss-color-muted">{{ t('Style') }}</div>
                    <div class="kiss-text-monospace kiss-size-small">{{ style }}</div>
                    <select v-model="style"><option v-for="s in styles" :value="s">{{ s }}</option></select>
                </kiss-card>
                <kiss-card class="kiss-padding-small kiss-overlay-input kiss-width-1-5@m" theme="bordered">
                    <div class="kiss-text-caption kiss-color-muted">{{ t('Size') }}</div>
                    <div class="kiss-text-monospace kiss-size-small">{{ size }}</div>
                    <select v-model="size"><option v-for="s in sizes" :value="s">{{ s }}</option></select>
                </kiss-card>
                <button type="button" :aria-label="t('Close')" class="kiss-input-blank kiss-cursor-pointer" kiss-dialog-close>
                    <kiss-svg class="kiss-color-muted" :src="$baseUrl('system:assets/icons/close.svg')" width="15"><canvas width="15" height="15"></canvas></kiss-svg>
                </button>
            </div>

            <div class="kiss-bgcolor-contrast kiss-position-relative kiss-padding kiss-bgcolor-transparentimage kiss-margin">
                <canvas width="600" height="200"></canvas>
                <div class="kiss-cover kiss-flex kiss-flex-middle kiss-flex-center">
                    <img class="kiss-responsive-height" :src="image" v-if="image">
                    <a class="kiss-cover" :href="image" target="_blank" rel="noopener" v-if="image"></a>
                    <div class="kiss-size-1 kiss-color-muted" v-if="!image"><icon size="large">photo</icon></div>
                </div>
            </div>

            <kiss-card class="kiss-flex kiss-flex-middle kiss-padding-small" theme="shadowed contrast" gap>
                <textarea autofocus class="kiss-input-blank kiss-flex-1" style="height:60px;max-height:150px;resize: none;" :placeholder="t('Describe your wanted image...')" v-model="prompt" @keydown.enter="send"></textarea>
                <button type="button" class="kiss-input-blank kiss-cursor-pointer" @click="send">
                    <kiss-svg :class="{'kiss-color-muted': !prompt.trim()}" :src="$baseUrl('autopilot:assets/icons/send.svg')" width="30" height="30"><canvas width="30" height="30"></canvas></kiss-svg>
                </button>
            </kiss-card>

            <div class="kiss-margin-small-top kiss-flex kiss-flex-middle kiss-button-group">
                <button type="button" class="kiss-button-cancel kiss-button kiss-flex-1" kiss-dialog-close>{{ t('Cancel') }}</button>
                <button type="button" class="kiss-button-confirm kiss-button kiss-button-primary kiss-flex-1" v-if="image" @click="chooseImage">{{ t('Choose image') }}</button>
            </div>
        </div>
    `
}
