
<kiss-container class="kiss-margin-small" size="medium">

<ul class="kiss-breadcrumbs">
    <li><a href="<?=$this->route('/system')?>"><?=t('Settings')?></a></li>
</ul>

<vue-view>

    <template>

        <div class="kiss-margin-large-bottom kiss-size-3 kiss-text-bold">
            <?=t('Sync')?>
        </div>

        <?=$this->render('sync:views/partials/menu.php', ['view' => 'settings'])?>

        <div>
            <kiss-card class="kiss-padding" theme="bordered contrast">
                <div class="kiss-text-caption kiss-color-muted">{{ t('Sync key') }}</div>
                <div class="kiss-margin-small-top kiss-text-bold kiss-text-monospace">
                    <?php if(!$syncKey): ?>
                        <div class="kiss-color-muted">{{ t('No sync key defined in the config') }}</div>
                    <?php else: ?>
                        <div class="kiss-size-large"><?=$syncKey?></div>
                    <?php endif ?>
                </div>
            </kiss-card>

            <form class="kiss-margin" v-if="!loading || targets.length" :class="{'kiss-disabled': loading}" @submit.prevent="save">

                <div class="kiss-text-caption">{{ t('Sync Targets') }}</div>

                <kiss-card class="animated fadeIn kiss-padding kiss-align-center kiss-text-caption kiss-margin-top" theme="bordered contrast" v-if="!targets.length">
                    <div class="kiss-text-bold">{{ t('No sync targets defined') }}</div>
                </kiss-card>

                <vue-draggable class="kiss-margin-top" v-model="targets" v-if="targets.length" handle=".fm-handle">

                    <kiss-card class="kiss-padding kiss-margin kiss-flex" theme="contrast shadowed" v-for="element in targets">

                        <a class="fm-handle kiss-margin-small-end kiss-color-muted"><icon>drag_handle</icon></a>
                        <div class="kiss-flex-1">

                            <div class="kiss-width-1-4@m"><input type="text" class="kiss-input kiss-input-small kiss-input kiss-text-bold" seamless="true" v-model="element.name" :placeholder="t('Name')" required></div>

                            <kiss-card class="kiss-margin-small">

                                <kiss-row class="kiss-margin" gap="small">

                                    <div class="kiss-flex-1">
                                        <div class="kiss-text-caption kiss-color-muted kiss-margin-xsmall-bottom">{{ t('Target url') }}</div>
                                        <input type="url" class="kiss-input" v-model="element.uri" placeholder="https://..." required>
                                    </div>
                                    <div class="kiss-width-1-3@m">
                                        <div class="kiss-text-caption kiss-color-muted kiss-margin-xsmall-bottom">{{ t('Sync key') }}</div>
                                        <input type="password" class="kiss-input" v-model="element.syncKey" :placeholder="t('Sync Key')" required>
                                    </div>

                                    <div>
                                        <div class="kiss-text-caption kiss-color-muted kiss-margin-xsmall-bottom">{{ t('Modes') }}</div>
                                        <field-boolean v-model="element.modes.push" label="Push"></field-boolean>
                                        <field-boolean v-model="element.modes.pull" label="Pull"></field-boolean>
                                    </div>
                                </kiss-row>

                            </kiss-card>

                        </div>
                        <a class="kiss-margin-small-start kiss-color-danger" @click="targets.splice(targets.indexOf(element), 1)"><icon>delete</icon></a>

                    </kiss-card>

                </vue-draggable>

                <div class="kiss-margin kiss-align-center">
                    <a class="kiss-size-large" @click="targets.push({name:'', uri:'', syncKey: '', modes:{pull:true, push:true}})"><icon>control_point</icon></a>
                </div>

                <app-actionbar>

                    <kiss-container size="medium">
                        <div class="kiss-flex kiss-flex-middle kiss-flex-end">

                            <button class="kiss-button kiss-button-primary">
                                {{ t('Save settings') }}
                            </button>
                        </div>
                    </kiss-container>

                </app-actionbar>
            </form>

            <app-loader class="kiss-margin" v-if="loading"></app-loader>

        </div>


    </template>

    <script type="module">

        export default {

            data() {

                return {
                    targets: <?=json_encode($targets)?>,
                    loading: false,
                }
            },

            methods: {

                save() {

                    this.loading = true;

                    this.$request('/sync/save', {targets: this.targets}).then(res => {
                        this.loading = false;
                        App.ui.notify('Settings updated!');
                    });
                }
            }

        }
    </script>

</vue-view>
</kiss-container>
