let instanceCount = 0;

export default {

    _meta: {
        label: 'Variants',
        info: 'Personalisation variants',
        icon: 'personi:icon.svg',
        settings: [
            {name: 'fields', type: 'fields-manager', opts: {i18n: false}},
        ],
        render(value, field, context) {

            return `<span class="kiss-badge kiss-badge-outline">${value && Array.isArray(value['personi:variants']) ? value['personi:variants'].length: 0}</span>`;
        }
    },

    data() {
        return {
            uid: `field-variants-${++instanceCount}`,
            val: this.modelValue,
            editForm: {}
        }
    },

    props: {
        modelValue: {
            type: Array,
            default: null
        },
        fields: {
            type: Array,
            default: []
        },
    },

    mounted() {


    },

    computed: {

        variants() {
            return (this.val && this.val['personi:variants']) || [];
        }
    },

    watch: {
        val: {
            handler() { this.update() },
            deep: true
        },
        modelValue(val) {
            this.val = this.modelValue;
        }
    },

    methods: {

        addVariant() {

            if (!this.val || !this.val['personi:variants']) {
                this.val = {'personi:variants': []}
            }

            this.val['personi:variants'].push({
                id: App.utils.nanoid(10),
                active: true,
                label: '',
                data: {},
                meta: null,
                audience: []
            });

            this.editForm[this.val['personi:variants'].length - 1] = true;
        },

        removeVariant(idx) {

            if (this.editForm[idx]) {
                delete this.editForm[idx];
            }

            this.val['personi:variants'].splice(idx, 1);
        },

        cloneVariant(idx) {

            let variant = JSON.parse(JSON.stringify(this.val['personi:variants'][idx]));

            variant.id = App.utils.nanoid(10);

            this.val['personi:variants'].splice(idx, 0, variant);
        },

        update() {
            this.$emit('update:modelValue', this.val ? this.val || {} : null)
        }
    },

    template: /*html*/`
        <div field="variants">

            <kiss-card class="kiss-padding-larger kiss-color-muted kiss-align-center" theme="contrast" v-if="!variants.length">
                <kiss-svg :src="$baseUrl('personi:icon.svg')" width="40" height="40"></kiss-svg>
                <div class="kiss-margin-small kiss-size-small">{{ t('Create first Variant' )}}</div>
            </kiss-card>

            <vue-draggable v-model="val['personi:variants']" handle=".fm-handle" item-key="id" v-if="variants.length">
                <kiss-card class="kiss-padding-small kiss-margin-small kiss-flex" gap="small" theme="shadowed contrast" hover="shadow" v-for="(element, index) in val['personi:variants']">
                    <a class="fm-handle kiss-color-muted"><icon>drag_handle</icon></a>
                    <div class="kiss-flex-1">
                        <div class="kiss-flex kiss-flex-middle">
                            <div class="kiss-margin-small-end"><field-boolean class="kiss-display-block" v-model="element.active"></field-boolean></div>
                            <div class="kiss-flex-1 kiss-size-small kiss-text-bold kiss-margin-end" :class="{'kiss-color-muted': !element.active}">
                                <input class="kiss-form-blank kiss-text-bold kiss-width-1-1" type="text" :placeholder="t('Variant')+' '+(index + 1)" v-model="element.label">
                            </div>
                            <a class="kiss-margin-end" :class="{'kiss-color-muted': !editForm[element.id]}" @click="editForm[element.id] = !editForm[element.id]"><icon>edit</icon></a>
                            <a class="kiss-margin-small-end" @click="cloneVariant(index)" title="Clone variant"><icon>content_copy</icon></a>
                            <a @click="removeVariant(index)"><icon class="kiss-color-danger" table-action="remove">delete</icon></a>
                        </div>
                        <div class="kiss-margin-small" v-if="editForm[element.id]">
                            <fields-renderer v-model="element.data" :fields="fields" :nested="true"></fields-renderer>
                        </div>
                        <div class="kiss-margin" v-if="editForm[element.id]">
                            <label class="kiss-text-capitalize">Meta</label>
                            <field-object v-model="element.meta" :placeholder="t('Add metadata')" :height="100"></field-object>
                        </div>
                        <div class="kiss-margin-small" :class="{'kiss-disabled': !element.active}">
                            <label class="kiss-text-capitalize">Audience</label>
                            <field-tags v-model="element.audience" :placeholder="t('Add audience')"></field-tags>
                        </div>
                    </div>
                </kiss-card>
            </vue-draggable>

            <div class="kiss-margin-small" v-if="Array.isArray(fields) && fields.length">
                <button type="button" class="kiss-button kiss-button-small" @click="addVariant"><icon class="kiss-margin-small-end">control_point</icon> {{ t('Add variant') }}</button>
            </div>

        </div>
    `
}
