<?php

namespace Pages\Controller;

use App\Controller\App;
use ArrayObject;

class Storefront extends App {

    protected $layout = 'app:layouts/canvas.php';

    protected function before() {

        if (!$this->isAllowed('pages/manage')) {
            return $this->stop(403);
        }

        $this->helper('theme')->favicon('pages:icon.svg');
    }

    public function frame() {

        $src = $this->param('src');

        if (!$src) {
            return false;
        }

        return $this->render('pages:views/storefront.php', \compact('src'));
    }
}
