<div class="kiss-margin-small">
    <kiss-container>

        <?=$contents?>

    </kiss-container>
</div>

<?php $this->start('app-side-panel') ?>

<kiss-card>

    <h2 class="kiss-size-4"><?=t('Lokalize')?></h2>

    <kiss-navlist>
        <ul>
            <li>
                <a class="kiss-flex kiss-flex-middle <?=($this->request->route === '/lokalize/projects' ? 'kiss-link-muted kiss-text-bold':'kiss-color-muted')?>" href="<?=$this->route('/lokalize/projects')?>">
                    <kiss-svg class="kiss-margin-small-end" src="<?=$this->base('lokalize:icon.svg')?>" width="20" height="20"><canvas width="20" height="20"></canvas></kiss-svg>
                    <?=t('Overview')?>
                </a>
            </li>
        </ul>
    </kiss-navlist>

    <vue-view class="kiss-margin">
        <template>

            <kiss-navlist>
                <ul>
                    <li class="kiss-nav-header kiss-margin-top kiss-margin-xsmall-bottom"><?=t('Projects')?></li>
                    <li v-for="project in processed">
                        <a class="kiss-flex kiss-flex-middle" gap="small" :class="project.isActive ? 'kiss-link-muted kiss-text-bold':'kiss-color-muted'"  :href="$routeUrl(`/lokalize/projects/project/${project.name}`)">
                            <div :style="{color: project.isActive && project.color || 'inherit' }"><kiss-svg :src="$baseUrl(project.icon || 'lokalize:icon.svg')" width="20" height="20"><canvas width="20" height="20"></canvas></kiss-svg></div>
                            <div class="kiss-flex-1 kiss-text-truncate">{{ project.label || project.name}}</div>
                            <span class="kiss-badge kiss-badge-outline kiss-padding-xsmall" :class="{'kiss-color-primary': '<?=$this->request->route?>'.match(`/lokalize/projects/project/${project.name}`)}">{{ project.status._overall }}%</span>
                        </a>
                    </li>
                </ul>
            </kiss-navlist>

            <app-loader class="kiss-display-inline-block" size="small" mode="dots" v-if="loading"></app-loader>

            <kiss-card class="kiss-color-muted kiss-size-small kiss-margin-small" v-if="!loading && projects && !projects.length">
                <?=t('No project created yet')?>
            </kiss-card>

            <a class="kiss-button kiss-button-small kiss-margin" href="<?=$this->route('/lokalize/projects/create')?>" v-if="!loading"><?=t('Create project')?></a>

        </template>

        <script type="module">

            export default {

                data() {
                    return {
                        projects: [],
                        loading: true
                    }
                },

                created() {

                    this.load();

                    AppEventStream.on('lokalize.projects.updated', () => {
                        this.load();
                    });
                },

                computed: {
                    processed() {

                        this.projects.forEach(project => {
                            project.isActive = '<?=$this->request->route?>'.match(`/lokalize/projects/project/${project.name}`)
                        });

                        return this.projects;
                    }
                },

                methods: {

                    load() {

                        this.loading = true;

                        this.$request('/lokalize/projects/load', {options:{}}).then(projects => {

                            this.projects = projects;
                            this.loading = false;
                        });
                    }

                }

            }
        </script>

    </vue-view>

</kiss-card>

<?php $this->end('app-side-panel') ?>
