export default {
    props: ['locales'],
    data() {
        return {
            locale: ''
        }
    },
    methods: {
        translate() {
            this.$call('translate', {locale: this.locale});
            this.$close();
        }
    },
    template: `
        <div>
            <div class="kiss-size-4 kiss-text-bold kiss-margin-small-bottom">${App.i18n.get('Auto Translate')}</div>
            
            <div class="kiss-margin-small">
                <label>${App.i18n.get('Target Locale')}</label>
                <select class="kiss-input" v-model="locale">
                    <option v-for="loc in locales" :value="loc.value">{{ loc.label }}</option>
                </select>
            </div>

            <div class="kiss-margin-top kiss-button-group kiss-flex-right">
                <button type="button" class="kiss-button" @click="$close()">${App.i18n.get('Cancel')}</button>
                <button type="button" class="kiss-button kiss-button-primary" @click="translate()" :disabled="!locale">${App.i18n.get('Translate')}</button>
            </div>
        </div>
    `
}
