<?php

namespace Lokalize\Translators;

class Deepl {

    protected array $config = [];

    public function __construct(array $config = []) {
        $this->config = $config;
    }

    public function translate(string $text, string $to, $context = null) {

        $ch = curl_init();

        $data = [
            'auth_key' => $this->config['apiKey'] ?? '',
            'text' => $text,
            'target_lang' => $to
        ];

        curl_setopt($ch, CURLOPT_URL, 'https://api-free.deepl.com/v2/translate');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));

        $error = null;
        $headers = [];
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            $error = ['error' => curl_error($ch)];
        }

        curl_close($ch);

        if ($error) {
            return $error;
        }

        $json = \json_decode($result, true);
        $translation = '';

        if (isset($json['translations'][0]['text'])) {
            $translation = $json['translations'][0]['text'];
        }

        return $translation;
    }
}
