export const getGroupColor = (group) => {

	if (!group) return 'currentColor';

	let colors = ["#e51c23", "#e91e63", "#9c27b0", "#673ab7", "#3f51b5", "#5677fc", "#03a9f4", "#00bcd4", "#009688", "#259b24", "#8bc34a", "#afb42b", "#ff9800", "#ff5722", "#795548", "#607d8b"]
    let hash = 0;

    for (var i = 0; i < group.length; i++) {
        hash = group.charCodeAt(i) + ((hash << 5) - hash);
        hash = hash & hash;
    }

    hash = ((hash % colors.length) + colors.length) % colors.length;
    return colors[hash];
}

export const generateNewComponentIds = (component) => {

    component.id = App.utils.nanoid();

    // Recursively handle children if they exist
    if (component.children && Array.isArray(component.children)) {
        component.children.forEach(child => generateNewComponentIds(child));
    }

    return component;
}
