
let pickComponent = {

    data() {
        return {
            mode: 'components'
        }
    },

    props: {

        components: {
            type: Object,
            default: {}
        },
        init: {
            type: Boolean,
            default: true
        },

        clipboard: {
            type: Boolean,
            default: true
        },
        shared: {
            type: Boolean,
            default: true
        },
        templates: {
            type: Boolean,
            default: true
        },

        layout: {
            type: Array,
            default: []
        },
        insertPosition: {
            type: Number,
            default: -1
        },
        globalComponents: {
            type: Object,
            default: null
        },
    },

    components: {
        componentsPicker: Vue.defineAsyncComponent(() =>
            App.utils.import('layout:assets/vue-components/layout/picker/components.js')
        ),
        sharedPicker: Vue.defineAsyncComponent(() =>
            App.utils.import('layout:assets/vue-components/layout/picker/shared.js')
        ),
        templatesPicker: Vue.defineAsyncComponent(() =>
            App.utils.import('layout:assets/vue-components/layout/picker/templates.js')
        ),
    },

    computed: {

        clipboardComponent() {

            if (!this.clipboard) return null;

            try {
                let history = JSON.parse(App.storage.get('layout.field.clipboard.history', '[]', true));
                
                if (!Array.isArray(history)) return null;

                return history.length ? history[0].component : null;
            } catch (e) {
                return null;
            }
        },

    },

    methods: {
        select(component) {
            this.$call('select', component);
            this.$close();
        },

        selectFromClipboard() {

            let history = [];

            try {
                history = JSON.parse(App.storage.get('layout.field.clipboard.history', '[]', true));
            } catch (e) {
                history = [];
            }

            if (!Array.isArray(history)) {
                history = [];
            }

            if (!history.length) {
                return;
            }

            if (history.length > 1) {

                this.$close();

                setTimeout(() => {
                    
                    this.$offcanvas('layout:assets/vue-components/layout/clipboard-manager.js', {
                        
                    }, {
                        paste: (component) => {
                            this.$call('selectFromClipboard', component);
                        }
                    }, {flip: true, size: 'medium'});

                }, 50); // wait for close animation? or just small delay
                
                return;
            }

            this.$call('selectFromClipboard', this.clipboardComponent);
            this.$close();
        },
    },

    template: /*html*/`
        <div class="app-offcanvas-container">

            <div class="kiss-padding kiss-size-4 kiss-text-bold kiss-flex kiss-flex-middle">
                <div class="kiss-margin-small-end">
                    <kiss-svg :src="$baseUrl('layout:assets/icons/component.svg')" width="40" height="40"></kiss-svg>
                </div>
                {{ t('Select Component') }}
            </div>

            <ul class="kiss-tabs-nav kiss-padding-left kiss-padding-right kiss-margin-small-bottom" v-if="shared || templates">
                <li :active="mode == 'components'"><a class="kiss-tabs-nav-link" @click="mode = 'components'">{{ t('Components') }}</a></li>
                <li :active="mode == 'shared'" v-if="shared"><a class="kiss-tabs-nav-link" @click="mode = 'shared'">{{ t('Shared') }}</a></li>
                <li :active="mode == 'templates'" v-if="templates"><a class="kiss-tabs-nav-link" @click="mode = 'templates'">{{ t('Templates') }}</a></li>
            </ul>

            <components-picker :components="components" :layout="layout" :select="select" :globalComponents="globalComponents" :insertPosition="insertPosition" :init="init" v-if="mode == 'components'"></components-picker>
            <shared-picker :components="components" :layout="layout" :select="select" :globalComponents="globalComponents" :insertPosition="insertPosition" v-if="mode == 'shared'"></shared-picker>
            <templates-picker :components="components" :layout="layout" :select="select" :globalComponents="globalComponents" :insertPosition="insertPosition" v-if="mode == 'templates'"></templates-picker>

            <div class="kiss-padding" v-if="clipboardComponent">
                <button class="kiss-button kiss-width-1-1" @click="selectFromClipboard">{{ t('Add component from clipboard') }}</button>
            </div>

        </div>
    `
}

export default pickComponent;
