<?php

namespace Layout\Controller;

use ArrayObject;

class Shared extends Controller {

    public function index() {
        return $this->render('layout:views/shared/index.php');
    }

    public function component($id = null) {

        if (!$id && !$this->param('component')) {
            return false;
        }

        $components = new ArrayObject($this->helper('layoutComponents')->components());

        $component = [
            'component' => null,
            'name' => null,
            'i18n' => false,
            'data' => new ArrayObject([]),
        ];

        if ($this->param('component')) {

            $_component = $this->param('component');

            if (!isset($components[$_component])) {
                return false;
            }

            $component['component'] = $_component;
        }

        if ($id) {

            $_component = $this->app->dataStorage->findOne('layout/components_shared', ['_id' => $id]);

            if (!$_component) {
                return false;
            }

            $component = \array_merge($component, $_component);
        }

        $meta = $components[$component['component']] ?? null;

        return $this->render('layout:views/shared/component.php', \compact('component', 'meta'));
    }

    public function save() {

        $this->hasValidCsrfToken(true);

        $component = $this->param('component');

        if (!$component) {
            return $this->stop(['error' => 'component data is missing'], 412);
        }

        $component['_modified'] = \time();
        $isUpdate = isset($component['_id']);

        if (!$isUpdate) {
            $component['_created'] = $component['_modified'];
        }

        if (!isset($component['name']) || !\trim($component['name'])) {
            return $this->stop(['error' => 'name required'], 412);
        }

        foreach (['name'] as $key) {
            $component[$key] = \strip_tags(\trim($component[$key]));
        }

        $this->app->dataStorage->save('layout/components_shared', $component);

        return $component;
    }

    public function clone($id = null) {

        if (!$id) {
            return false;
        }

        $component = $this->app->dataStorage->findOne('layout/components_shared', ['_id' => $id]);

        if (!$component) {
            return false;
        }

        unset($component['_id'], $component['_created'], $component['_modified']);

        if ($component['name']) {
            $component['name'] .= ' (Clone)';
        }

        $components = new ArrayObject($this->helper('layoutComponents')->components());
        $meta = $components[$component['component']] ?? null;

        return $this->render('layout:views/shared/component.php', \compact('component', 'meta'));
    }

    public function remove() {

        $this->hasValidCsrfToken(true);

        $component = $this->param('component');

        if (!$component || !isset($component['_id'], $component['name'])) {
            return $this->stop(['error' => 'component is missing'], 412);
        }

        $this->app->dataStorage->remove('layout/components_shared', ['_id' => $component['_id']]);

        $this->app->trigger('layout.shared.remove', [$component]);

        return ['success' => true];
    }


    public function load() {

        $this->helper('session')->close();
        $this->hasValidCsrfToken(true);

        $components = $this->app->dataStorage->find('layout/components_shared', [
            'sort' => ['name' => 1]
        ])->toArray();

        return $components;
    }
}
