export default {

    components: {
        'inbox-recent-submissions': Vue.defineAsyncComponent(() =>
            App.utils.import('inbox:assets/vue-components/inbox-recent-submissions.js')
        )
    },

    props: {
        forms: {
            type: Array,
            default: () => []
        }
    },

    template: /*html*/`
        <kiss-card>
            <div class="kiss-text-caption kiss-text-bold">{{ t('Inbox') }}</div>
            <div class="kiss-color-muted kiss-size-small kiss-margin-xsmall">{{ t('Latest form submissions') }}</div>

            <inbox-recent-submissions :forms="forms"></inbox-recent-submissions>

            <div class="kiss-margin-small">
                <a class="kiss-button kiss-button-small" :href="$routeUrl('/inbox')">{{ t('Go to Inbox') }}</a>
            </div>

        </kiss-card>
    `
}
