<?php

$this->helper('license')->require();

// Register routes
$this->bindClass('Detektivo\\Controller\\Idx', '/detektivo/idx');
$this->bindClass('Detektivo\\Controller\\Detektivo', '/detektivo');

// events

$this->on('app.layout.init', function() {

    if (!$this->helper('acl')->isAllowed('detektivo/manage')) {
        return;
    }

    $this->helper('menus')->addLink('modules', [
        'label'  => 'Detektivo',
        'icon'   => 'detektivo:icon.svg',
        'route'  => '/detektivo',
        'active' => false,
        'group'  => 'Addons',
        'prio'   => 1
    ]);
});

$this->on('app.permissions.collect', function($permissions) {

    $permissions['Detektivo'] = [
        'detektivo/manage' => 'Manage indexes',
        'detektivo/api/search' => 'API access',
    ];
});

$this->on('app.search', function($search, $findings) {

    if (!$this->helper('acl')->isAllowed('detektivo/manage')) {
        return;
    }

    $indexes = $this->module('detektivo')->indexes();

    foreach ($indexes as $name => $index) {

        if (stripos($name, $search) !== false || stripos($index['label'], $search) !== false) {

            $findings[] = [
                'title' => $index['label'] ? $index['label'] : $name,
                'route' => $this->routeUrl("/detektivo/idx/{$name}"),
                'group' => 'Detektivo',
                'icon' => 'detektivo:assets/icons/index.svg'
            ];
        }

        if ($index['type'] === 'content:collection') {

            $model = $this->module('content')->model($index['meta']['model']);
            $idx = $this->module('detektivo')->index($name);

            $tField = array_find($index['fields'], function($field) {
                return in_array(strtolower($field), ['title', 'name', 'label', 'heading', 'subject', 'caption', 'topic']);
            });

            $result = $idx->search($search, [
                'limit' => 5,
            ]);

            foreach ($result['hits'] as $item) {

                $id = explode('_', $item['id'], 2)[0];
                $icon = "content:assets/icons/{$model['type']}.svg";

                if ($tField && isset($item[$tField]) && is_string($item[$tField]) && $item[$tField]) {
                    $title = $item[$tField];
                } else {

                    unset($item['id']);

                    $title = \IndexLite\Utils::stringifyValue($item, [
                        'ignoreKeyPattern' => '#^_#'
                    ]);

                    if (strlen($title) > 50) {
                        $title = substr($title, 0, 50) . '...';
                    }
                }

                if (isset($model['icon']) && $model['icon']) {
                    $icon = $model['icon'];
                }

                $findings[] = [
                    'title' => $title,
                    'route' => $this->routeUrl("/content/{$model['type']}/item/{$model['name']}/{$id}"),
                    'group' => 'Content',
                    'icon' => $icon,
                    'context' => isset($model['label']) && $model['label'] ? $model['label'] : $model['name']
                ];
            }
        }
    }
});
