<?php

/**
 * Get System Info Tool
 * Get basic information about the Cockpit system
 */

return [
    'name' => 'getSystemInfo',
    'description' => 'Get basic information about the Cockpit system',
    'parameters' => [
        'type' => 'object',
        'properties' => new \stdClass(),
        'required' => [],
        'additionalProperties' => false
    ],
    'handler' => function($args, $app) {
        // Get content models count
        $models = $app->module('content')->models();
        $collectionsCount = 0;
        if (is_array($models)) {
            foreach ($models as $model) {
                if (($model['type'] ?? 'collection') === 'collection') {
                    $collectionsCount++;
                }
            }
        }

        // Get user count safely
        $userCount = 0;
        try {
            if ($app->datastore) {
                $userCount = $app->datastore->count('system/users');
            }
        } catch (\Exception) {
            // Datastore not available
        }

        // Get assets count safely
        $assetCount = 0;
        try {
            if ($app->datastore) {
                $assetCount = $app->datastore->count('assets');
            }
        } catch (\Exception) {
            // Datastore not available
        }

        return [
            'version' => $app->retrieve('app.version'),
            'debug' => $app->retrieve('debug'),
            'collections' => $collectionsCount,
            'users' => $userCount,
            'assets' => $assetCount,
            'locales' => $app->module('system')->locales(),
            'current_user' => [
                'user' => $app->helper('auth')->getUser('user'),
                'name' => $app->helper('auth')->getUser('name'),
                'email' => $app->helper('auth')->getUser('email'),
                'role' => $app->helper('auth')->getUser('role')
            ]
        ];
    },
    'options' => ['permission' => 'autopilot/tools/read']
];