<?php

$this->helper('license')->require();

// Register routes
$this->bindClass('Autopilot\\Controller\\Autopilot', '/autopilot');
$this->bindClass('Autopilot\\Controller\\TestChat', '/autopilot/test');

// events

$this->on('app.permissions.collect', function ($permissions) {

    $permissions['Autopilot'] = [
        'autopilot/available' => 'Autopilot availability',
        'autopilot/tools/read' => 'Use read-only agent tools (list, search, view)',
        'autopilot/tools/write' => 'Use write agent tools (create, update)',
        'autopilot/tools/delete' => 'Use delete agent tools (remove content)',
        'autopilot/tools/admin' => 'Use admin agent tools (system configuration)',
    ];
});

$this->on('app.layout.init', function () {

    $this->helper('theme')->vars('autopilot', $this->module('autopilot')->apiKey() ? true : false);

    if (!$this->module('autopilot')->apiKey()) {
        return;
    }

    $this->on('app.layout.assets', function (array &$assets, $context) {

        if (!$this->module('autopilot')->apiKey()) {
            return;
        }

        if ($context === 'app:footer') $assets[] = ['src' => 'autopilot:assets/js/autopilot.js', 'type' => 'module'];
    });

    $this->start('app.layout.header');
?>
    <div>
        <button type="button" id="btnAutopilotAssistent" class="kiss-input-blank kiss-cursor-pointer" title="Autopilot Assistant">
            <kiss-svg src="<?=$this->baseUrl('autopilot:icon.svg')?>" width="30" height="30"></kiss-svg>
        </button>
        <script>

            document.getElementById('btnAutopilotAssistent').addEventListener('click', function() {

                VueView.ui.modal('autopilot:assets/dialogs/chat.js');
            });
        </script>
    </div>
<?php
    $this->end('app.layout.header');
});
