export default {

    data() {

        return {
            targets: null,
            target: null,
            mode: null,
            syncAssets: true,
            loading: true,
        }
    },

    props: {

        caption: {
            type: String,
            default: 'Sync item'
        },

        context: {
            type: Object,
            default: null
        },

        job: {
            type: String,
            default: null
        },

        item: {
            type: Object,
            default: null
        }
    },

    mounted() {

        this.$request('/sync/utils/targets').then(targets => {

            this.targets = targets;

            if (this.targets.length === 1) {
                this.target = this.targets[0];
            }

            this.loading = false;
        });
    },

    computed: {

        modes() {

            let modes = [];

            if (this.target) {
                Object.keys(this.target.modes).forEach(mode => {
                    if (this.target.modes[mode]) modes.push(mode);
                });
            }

            return modes;
        }
    },

    watch: {
        target() {

            this.mode = null;

            if (this.target && Object.values(this.target.modes).filter(v => v).length === 1) {
                this.mode = this.target.modes.pull ? 'pull' : 'push';
            }
        }
    },

    methods: {

        sync() {

            let target = Object.assign({
                mode: this.mode,
            }, this.target);

            let payload = Object.assign({
                item: this.item,
                syncAssets: this.syncAssets,
            },this.context || {});

            this.loading = true;

            this.$request('/sync/utils/syncItem', {job: this.job, target, payload}).then(rsp => {

                if (rsp.item) {
                    Object.assign(this.item, rsp.item);
                }

                this.loading = false;
                App.ui.notify(rsp.message || rsp.error || 'Content synced!');

            }).catch(rsp => {
                this.loading = false;
                App.ui.notify(rsp.message || rsp.error || 'Sync failed', 'error');
            });
        },
    },

    template: /*html*/`
    <div>

        <div class="kiss-size-4 kiss-text-bold kiss-margin kiss-flex kiss-flex-middle">
            <div></div>
            <div class="kiss-flex-1">{{ t(this.caption) }}</div>
        </div>

        <app-loader class="kiss-margin-large" v-if="loading"></app-loader>

        <div class="kiss-margin" v-if="!loading">
            <div class="kiss-size-xsmall">{{ t('Target') }}</div>
            <div class="kiss-margin-small-top kiss-color-muted kiss-size-4" v-if="!targets.length">
                {{ t('No targets defined') }}
            </div>
            <div class="kiss-margin-small-top" v-if="targets.length">
                <select class="kiss-input kiss-width-1-1" v-model="target">
                    <option></option>
                    <option v-for="t in targets" :value="t">{{ t.label || t.name }}</option>
                </select>
            </div>
        </div>

        <div class="kiss-margin" v-if="!loading && modes.length">
            <div class="kiss-size-xsmall">{{ t('Mode') }}</div>
            <div class="kiss-margin-small-top" v-if="targets.length">
                <select class="kiss-input kiss-width-1-1" v-model="mode">
                    <option></option>
                    <option v-for="m in modes" :value="m">{{ m }}</option>
                </select>
            </div>
        </div>

        <div class="kiss-margin" v-if="!loading">
            <field-boolean class="kiss-margin-small" v-model="syncAssets" :label="t('Autosync assets')"></field-boolean>
        </div>

        <div class="kiss-button-group kiss-flex kiss-child-width-1-2" :class="{'kiss-disabled': loading}">
            <button type="button" class="kiss-button" autofocus kiss-dialog-close>{{ t('Cancel') }}</button>
            <button type="button" class="kiss-button" :class="{'kiss-button-primary': (target && mode)}" @click="sync()" :disabled="!(target && mode)">Sync</button>
        </div>

    </div>
`,
}
