export default {

    data() {

    },

    components: {
        lokalizeProject: Vue.defineAsyncComponent(() =>
            App.utils.import('pages:assets/storefront/admin/modules/lokalize/vue-components/project.js')
        ),
    },

    props: {
        projects: {
            type: Array,
            default: []
        },
    },

    template: /*html*/`
        <div>
            <div class="kiss-size-4 kiss-text-bold kiss-flex kiss-flex-middle kiss-margin">
                <kiss-svg class="kiss-margin-small-end" :src="$baseUrl('lokalize:icon.svg')" width="30" height="30"><canvas width="30" height="30"></canvas></kiss-svg>
                Lokalize
            </div>
            <div class="kiss-margin" v-if="Array.isArray(projects) && projects.length">
                <div class="kiss-text-caption kiss-color-muted">{{ t('Projects') }}</div>
                <lokalize-project class="kiss-margin-small" v-for="p in projects" :project="p"></lokalize-project>
            </div>
        </div>
    `
}
