<?php

    $types = $this->module('detektivo')->indexTypes();
    $isUpdate = isset($index);
    $index = $index ?? [
        'name' => '',
        'label' => '',
        'info' => '',
        'type' => 'index',
        'fields' => [],
        'meta' => new ArrayObject([])
    ];

?>
<kiss-container class="kiss-margin" size="small">

    <vue-view>

        <template>

            <ul class="kiss-breadcrumbs">
                <li><a href="<?=$this->route('/detektivo')?>"><?=t('Detektivo')?></a></li>
                <li>
                    <span v-if="!isUpdate"><?=t('Create index')?></span>
                    <span v-if="isUpdate"><?=t('Update index')?></span>
                </li>
            </ul>

            <div class="kiss-margin-large kiss-size-3 kiss-text-bold">
                <span v-if="!isUpdate"><?=t('Create index')?></span>
                <span v-if="isUpdate"><?=t('Update index')?></span>
            </div>

            <kiss-grid class="kiss-margin" cols="3@m" gap="small">

                <kiss-card class="kiss-flex kiss-padding kiss-position-relative" theme="bordered" :class="index.type == t.name ? '': 'kiss-color-muted'" :style="{borderColor:index.type == t.name ? 'var(--kiss-color-primary)': null}" v-for="t in types">
                    <div class="kiss-margin-small-end"><kiss-svg :src="$baseUrl(t.icon || 'detektivo:assets/icons/index.svg')" width="40" height="40"><canvas width="30" height="30"></canvas></kiss-svg></div>
                    <div class="kiss-size-small">
                        <strong>{{ t.label || t.name }}</strong>
                        <div class="kiss-size-xsmall kiss-color-muted kiss-margin-xsmall-top">
                            {{ t.info || '...' }}
                        </div>
                    </div>
                    <a class="kiss-cover" @click="setType(t.name)"></a>
                </kiss-card>
            </kiss-grid>

            <form :class="{'kiss-disabled':saving}" @submit.prevent="save">

                <div class="kiss-margin">
                    <label><?=t('Name')?><icon class="kiss-size-5 kiss-color-danger kiss-margin-xsmall-start" title="Required">trip_origin</icon></label>
                    <input class="kiss-input" type="text" pattern="[a-zA-Z0-9_]+" v-model="index.name" required>
                </div>

                <div class="kiss-margin">
                    <label><?=t('Display name')?></label>
                    <input class="kiss-input" type="text" v-model="index.label" :placeholder="index.name">
                </div>

                <div class="kiss-margin">
                    <label><?=t('Info')?></label>
                    <textarea class="kiss-input kiss-textarea" style="height:100px;" v-model="index.info"></textarea>
                </div>

                <div class="kiss-margin">
                    <label><?=t('Color')?></label>
                    <field-color v-model="index.color"></field-color>
                </div>

                <div class="kiss-margin">
                    <label><?=t('Fields')?><icon class="kiss-size-5 kiss-color-danger kiss-margin-xsmall-start" title="Required">trip_origin</icon></label>
                    <field-tags :placeholder="t('Add field...')" v-model="index.fields" :src="fieldsSuggestions"></field-tags>
                </div>

                <div class="kiss-margin-large" v-if="indexType.meta">

                    <div class="kiss-flex kiss-flex-middle kiss-margin">
                        <div class="kiss-size-xsmall kiss-text-bold kiss-text-upper kiss-color-muted kiss-margin-small-end"><?=t('Configuration')?></div>
                        <hr class="kiss-flex-1 kiss-margin-remove">
                    </div>

                    <fields-renderer id="indexTypeMeta" v-model="index.meta" :fields="indexType.meta"></fields-renderer>
                </div>

                <app-actionbar>

                    <kiss-container size="small">
                        <div class="kiss-flex kiss-flex-middle">
                            <a class="kiss-button" :href="$routeUrl(`/detektivo/idx/${index.name}`)" v-if="isUpdate"><?=t('Goto index items')?></a>
                            <div class="kiss-flex-1"></div>
                            <div class="kiss-button-group">
                                <a class="kiss-button" href="<?=$this->route('/detektivo')?>">
                                    <?=t('Cancel')?>
                                </a>
                                <button type="submit" class="kiss-button kiss-button-primary">
                                    <span v-if="!isUpdate"><?=t('Create index')?></span>
                                    <span v-if="isUpdate"><?=t('Update index')?></span>
                                </button>
                            </div>
                        </div>
                    </kiss-container>

                </app-actionbar>

            </form>


        </template>


        <script type="module">

            export default {

                data() {
                    return {

                        types: <?=json_encode($types)?>,
                        isUpdate: <?=json_encode($isUpdate)?>,
                        index: <?=json_encode($index)?>,
                        saving: false
                    }
                },

                computed: {

                    indexType() {
                        return this.types[this.index.type] || {};
                    },

                    fieldsSuggestions() {

                        if (!this.indexType || !this.indexType.fields) {
                            return null;
                        }

                        return {
                            route: '/detektivo/fieldSuggestions',
                            params: {
                                type: this.index.type,
                                meta: this.index.meta
                            },
                        };
                    }
                },

                methods: {

                    setType(typeName) {
                        this.index.type = typeName;
                        this.index.meta = {};
                    },

                    save: function () {

                        if (!this.index.fields.length) {
                            App.ui.notify('Please add at least one field to index!', 'error');
                            return;
                        }

                        if (this.indexType.meta) {
                            let validate = {root: document.querySelector(`#indexTypeMeta`)};

                            if (validate.root) {
                                App.trigger('fields-renderer-validate', validate);
                            }

                            if (validate.errors) {
                                return;
                            }
                        }

                        this.saving = true;

                        this.$request('/detektivo/save', {
                            index: this.index,
                            isUpdate: this.isUpdate
                        }).then(index => {

                            App.ui.notify(this.isUpdate ? 'Index updated!' : 'Index created!');
                            this.isUpdate = true;

                        }).catch(res => {
                            App.ui.notify(res.error || 'Index saving failed!', 'error');
                        }).finally(() => {
                            this.saving = false;
                        });

                    }
                }
            }

        </script>


    </vue-view>


</kiss-container>
