function fuzzySearch(needle, haystack) {
    let hlen = haystack.length;
    let nlen = needle.length;

    if (nlen > hlen) {
        return false;
    }
    if (nlen === hlen) {
        return needle === haystack;
    }

    outer: for (let i = 0, j = 0; i < nlen; i++) {
        let nch = needle.charCodeAt(i);

        while (j < hlen) {
            if (haystack.charCodeAt(j++) === nch) {
                continue outer;
            }
        }

        return false;
    }
    return true;
}

export default {

    _meta: {
        size: 'large',
        escape: true
    },

    data() {

        return {
            prompt: '',
            suggestion: false,
            msg: null,
        }
    },

    props: {
        fields: {
            type: Array,
            default: []
        },
        root: {
            type: Object,
            default: null
        },
        handler: {
            type: Function,
            default: null
        }
    },

    methods: {

        applyMsg() {

            if (!this.msg) return;
            this.root.updateValue(this.msg);
            this.$close();
        },

        onSubmit(e) {

            if (this.$refs.autocomplete.isAutocompleteActive) {
                return;
            }

            if (e) {
                e.preventDefault();
            }

            if (!this.prompt.trim() || !this.handler) {
                return;
            }

            this.msg = null;

            App.ui.block(App.i18n.get('Generating text'));

            this.handler(this.prompt, (msg) => {
                this.msg = msg;
                App.ui.unblock();
            });
        }
    },

    template: /*html*/`
        <form class="kiss-position-relative" @submit.prevent="onSubmit">

            <div class="kiss-flex kiss-flex-middle kiss-margin">
                <div>
                    <kiss-svg class="kiss-color-primary" :src="$baseUrl('autopilot:icon.svg')" width="50" height="50"></kiss-svg>
                </div>
                <div class="kiss-flex-1 kiss-margin-start">
                    <span class="kiss-size-xsmall kiss-color-muted kiss-text-upper">Autopilot</span>
                    <kiss-row class="kiss-flex-middle">
                        <div class="kiss-size-4 kiss-flex-1">
                            <span class="kiss-text-capitalize">{{ t('Text Generation') }}</span>
                        </div>
                    </kiss-row>
                </div>
                <button type="button" :aria-label="t('Close')" class="kiss-input-blank kiss-cursor-pointer" kiss-dialog-close>
                    <kiss-svg class="kiss-color-muted" :src="$baseUrl('system:assets/icons/close.svg')" width="15"><canvas width="15" height="15"></canvas></kiss-svg>
                </button>
            </div>

            <div class="kiss-margin" v-if="msg">
                <kiss-card class="kiss-padding" theme="shadowed contrast">
                    <div class="kiss-color-muted kiss-text-caption kiss-margin-small">{{ t('Suggestion') }}</div>
                    <div style="max-height:30vh;overflow:scroll;" v-html="msg"></div>
                </kiss-card>
            </div>

            <kiss-card class="kiss-flex kiss-flex-middle kiss-padding-small" theme="shadowed contrast" gap>
                <app-textcomplete class="kiss-flex-1" :items="fields" trigger="@" ref="autocomplete">
                    <textarea autofocus class="kiss-input-blank kiss-width-1-1" style="height:100px;max-height:150px;resize: none;" :placeholder="t('Instructions...')" v-model="prompt" @keydown.enter="onSubmit" ref="prompt"></textarea>
                </app-textcomplete>
                <button type="submit" class="kiss-input-blank kiss-cursor-pointer"  :disabled="!prompt.trim()">
                    <kiss-svg :class="{'kiss-color-muted': !prompt.trim()}" :src="$baseUrl('autopilot:assets/icons/send.svg')" width="30" height="30"><canvas width="30" height="30"></canvas></kiss-svg>
                </button>
            </kiss-card>

            <div class="kiss-margin-small-top kiss-flex kiss-flex-middle kiss-button-group">
                <button type="button" class="kiss-button-cancel kiss-button kiss-flex-1" kiss-dialog-close>{{ t('Cancel') }}</button>
                <button type="button" class="kiss-button-confirm kiss-button kiss-button-primary kiss-flex-1" v-if="msg" @click="applyMsg">{{ t('Accept suggestion') }}</button>
            </div>

        </form>
    `
}
