<?php

use GraphQL\Type\Definition\Type;
use GraphQL\Type\Definition\ObjectType;
use App\GraphQL\Types\JsonType;

$gql->queries['fields']['pagesMenu'] = [

    'type' => JsonType::instance(),

    'args' => [
        'name'  => Type::nonNull(Type::string()),
        'inactive'  => ['type' => Type::boolean(), 'defaultValue' => false],
        'locale'  => Type::string(),
    ],

    'resolve' => function ($root, $args) use($app) {

        if (!$app->helper('acl')->isAllowed('pages/api/read', $app->helper('auth')->getUser('role'))) {
            $app->response->status = 403;
            return null;
        }

        $locale = $args['locale'] ?? 'default';

        $menus = $app->module('pages')->menus([
            'filter'=> ['name' => $args['name']],
            'limit' => 1
        ], ['resolveLinks' => true, 'filterInactiveLinks' => !($args['inactive'] ?? false)]);

        return isset($menus[0]) ? $app->helper('locales')->applyLocales($menus[0], $locale) : null;
    }
];
