<?php

namespace Pages\Controller;

use ArrayObject;

class Settings extends Controller {

    public function index() {

        $settings = $this->module('pages')->settings(true);

        $locales = $this->helper('locales')->locales();

        $locales[0]['visible'] = true;

        return $this->render('pages:views/settings/index.php', compact('settings', 'locales'));
    }

    public function save() {

        $this->hasValidCsrfToken(true);

        $settings = $this->param('settings', []);

        $this->trigger('pages.settings.save', [&$settings]);

        $this->app->dataStorage->setKey('pages/options', 'settings', $settings);

        return $settings;
    }
}
