export default {

    data() {
        return {
            item: {
                data: JSON.parse(JSON.stringify(this.data || {})),
                meta: JSON.parse(JSON.stringify(this.meta || {})),
            },
        };
    },

    props: {
        data: {
            type: Object,
            default: () => ({})
        },
        meta: {
            type: Object,
            default: () => ({})
        },
        fields: {
            type: Array,
            default: () => []
        },
        title: {
            type: String,
            default: 'Column settings'
        }
    },

    methods: {
        save() {
            // Validate using fields-renderer like other editors do
            const validate = { root: this.$el };
            App.trigger('fields-renderer-validate', validate);
            if (validate.errors) return;

            this.$call('save', this.item);
            this.$close();
        }
    },

    template: /*html*/`
        <div>
            <div class="kiss-margin-bottom kiss-size-4 kiss-text-bold">{{ title }}</div>

            <div class="kiss-margin kiss-dialog-overflow">
                <kiss-tabs>
                    <tab class="animated fast fadeIn" :caption="t('Data')" v-if="fields && fields.length">
                        <fields-renderer v-model="item.data" :fields="fields"></fields-renderer>
                    </tab>
                    <tab class="animated fast fadeIn" :caption="t('Meta')">
                        <field-object v-model="item.meta"></field-object>
                    </tab>
                </kiss-tabs>
            </div>

            <div class="kiss-margin-top kiss-flex kiss-flex-middle kiss-button-group">
                <button type="button" class="kiss-button kiss-flex-1" @click="$close()">{{ t('Cancel') }}</button>
                <button type="button" class="kiss-button kiss-button-primary kiss-flex-1" @click="save">{{ t('Save') }}</button>
            </div>
        </div>
    `
}
