<?php

$this->helper('license')->require();

// Register routes
$this->bindClass('Webhooks\\Controller\\Webhooks', '/webhooks');
$this->bindClass('Webhooks\\Controller\\Utils', '/webhooks/utils');

//events
$this->on('app.permissions.collect', function($permissions) {

    $permissions['Webhooks'] = [
        'webhooks/manage' => 'Manage webhooks',
    ];
});

$this->on('app.settings.collect', function($settings) {

    $settings['Addons'][] = [
        'icon' => 'webhooks:icon.svg',
        'route' => '/webhooks',
        'label' => 'Webhooks',
        'permission' => 'webhooks/manage'
    ];
});

$this->on('app.search', function($search, $findings) {

    if (!$this->helper('acl')->isAllowed('webhooks/manage')) {
        return;
    }

    if (stripos('Webhooks', $search) !== false || stripos('Hooks', $search) !== false) {
        $findings[] = [
            'title' => 'Webhooks',
            'route' => $this->routeUrl('/webhooks'),
            'group' => 'Webhooks',
            'icon' => 'webhooks:icon.svg'
        ];
    }
});

