<?php

namespace Sync\Controller;

use App\Controller\App;

class Utils extends App {

    protected function before() {

        $this->helper('session')->close();

        if (!$this->isAllowed('sync/manage')) {
            return $this->stop(401);
        }
    }

    public function targets() {
        return $this->app->dataStorage->getKey('cockpit', 'sync.targets', []);
    }

    public function syncItem() {

        $job     = $this->param('job');
        $target  = $this->param('target');
        $payload = $this->param('payload');

        return $this->helper('sync')->syncItem($job, $target, $payload);
    }

}
