<?php $this->start('app.layout.head') ?>

<?=$this->assets([
    'pages:assets/storefront/admin/storefront.css',
    ['src' => 'app:assets/js/admin.js', 'type' => 'module'],
    ['src' => 'pages:assets/storefront/admin/storefront.js', 'type' => 'module'],
], $this->retrieve('app.version'));?>

<?php $this->end('app.layout.head') ?>

<vue-view>

    <div class="storefront-container kiss-flex kiss-flex-column" style="height:100vh;padding: 20px;" :style="{opacity:init ? 1:0}">

        <div class="storefront-header kiss-flex kiss-flex-middle">
            <div class="kiss-margin-small-end">
                <img class="app-logo" src="<?=$this->helper('theme')->logo()?>" alt="Logo" style="height:30px;width:auto;">
            </div>
            <div class="kiss-flex-1">
                <span class="kiss-text-bold"><?=$this['app.name']?></span>
            </div>
            <a class="kiss-margin-large-start" :href="src">
                <kiss-svg class="kiss-color-muted" :src="$baseUrl('system:assets/icons/close.svg')" width="16"><canvas width="16" height="16"></canvas></kiss-svg>
            </a>
        </div>
        <div class="kiss-flex kiss-flex-1">
            <div class="storefront-sidebar kiss-margin-end" style="width:300px;">
                
                <app-loader v-if="!init"></app-loader>

                <div class="kiss-margin-top kiss-padding kiss-color-muted" v-if="storefront && !hasModules">
                    {{ t('No content modules found on the current page') }}
                </div>

                <div class="kiss-margin-top" v-if="hasModules">

                    <div v-if="!activeModule">

                        <div class="animated fadeInLeft">
                            <a class="kiss-display-block kiss-padding-small kiss-margin-small-bottom kiss-card kiss-card-hover kiss-flex kiss-flex-middle" @click="activeModule = name" v-for="name in Object.keys(modules)">
                                <div class="kiss-size-4 kiss-text-capitalize kiss-text-bold">{{ name }}</div>
                                <div class="kiss-flex-1"></div>
                                <icon class="kiss-color-muted">chevron_right</icon>
                            </a>
                        </div>
                    </div>

                    <div class="kiss-margin-bottom animated fadeInLeft fast" v-if="activeModule && hasMultipleModules">
                        <a class="kiss-flex kiss-flex-middle kiss-text-caption kiss-text-bold kiss-link-muted" @click="activeModule = null">
                            <icon class="kiss-margin-small-end">arrow_back</icon> {{ t('Back') }}
                        </a>
                    </div>

                    <div class="animated fast" :class="hasMultipleModules ? 'fadeInLeft' : 'fadeIn'" v-if="activeModule">
                        <component :is="'storefront-module-'+activeModule" v-bind="modules[activeModule]" :locale="locale" ref="modulecomponent" @storefront:refresh="reloadIframe" @storefront:highlight="highlight"></component>
                    </div>

                </div>

            </div>
            <div class="storefront-preview kiss-bgcolor-contrast kiss-flex kiss-flex-column kiss-flex-1">
                <kiss-card class="kiss-padding kiss-flex" theme="contrast shadowed" style="z-index:1" gap="small">

                    <div class="kiss-size-small kiss-flex-1 kiss-margin-end">
                        <strong :class="{'kiss-color-danger': !title.trim()}">{{title || 'No title'}}</strong>
                        <div class="kiss-flex kiss-flex-middle kiss-size-xsmall kiss-color-muted kiss-text-truncate" gap="small">
                            <span class="kiss-badge kiss-text-upper" v-if="locale && locale !== 'default'">{{locale}}</span>
                            {{src}}
                        </div>
                    </div>
                    <div class="kiss-size-4 kiss-margin-end kiss-visible@m"><a class="kiss-link-muted" @click="reloadIframe"><icon class="larger">refresh</icon></a></div>
                    <div class="kiss-size-4 kiss-visible@m"><a :class="(device=='phone') ? 'kiss-color-primary':'kiss-color-muted'" @click="device='phone'"><icon class="larger">smartphone</icon></a></div>
                    <div class="kiss-size-4 kiss-visible@m"><a :class="(device=='tablet') ? 'kiss-color-primary':'kiss-color-muted'" @click="device='tablet'"><icon class="larger">tablet_mac</icon></a></div>
                    <div class="kiss-size-4 kiss-visible@m"><a :class="(device=='computer') ? 'kiss-color-primary':'kiss-color-muted'" @click="device='computer'"><icon class="larger">desktop_windows</icon></a></div>

                </kiss-card>
                <div class="kiss-flex-1 kiss-position-relative">
                    <div class="kiss-cover">
                        <iframe :src="src" @load="updateSrc" :style="Object.assign(modes[device])" :device="device" ref="preview"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="module">

        export default {

            data() {
                return {
                    init: false,
                    validated: false,
                    src: '<?=$src?>',
                    title: '',
                    locale: 'default',
                    storefront: null,
                    activeModule: null,
                    device: 'computer',
                    modes: {
                        phone: {width: '360px', height: '640px'},
                        tablet: {width: '768px', height: '1024px'},
                        computer: {width: '100%', height: '100%'},
                    }
                }
            },

            computed: {

                hasModules() {
                    return Object.keys(this.modules).length > 0;
                },

                hasMultipleModules() {
                  return Object.keys(this.storefront.modules).length > 1;
                },

                modules() {

                    if (!this.storefront || !this.storefront.modules) return {};

                    let modules = {};

                    Object.keys(this.storefront.modules || {}).forEach(_module => {

                        if (!VueView.components[`storefront-module-${_module}`]) {
                            return;
                        }

                        modules[_module] = this.storefront.modules[_module];
                    });

                    return modules;
                }
            },

            mounted() {

                window.addEventListener('message', (e) => {

                    if (!e.data.event) return;

                    let event = e.data.event;
                    let data = e.data.data || {};

                    switch (event) {
                        case 'storefront:load':

                            this.src = data.src;
                            this.title = data.title;
                            this.storefront = data.storefront;
                            this.activeModule = null;
                            this.locale = this.storefront.locale || 'default';

                            if (data.storefront?.modules && Object.keys(data.storefront.modules).length === 1) {
                                this.activeModule = Object.keys(data.storefront.modules)[0];
                            }

                            this.validated = true;
                            this.init = true;
                            break;
                        case 'storefront:unload':
                            this.storefront = null;
                            this.activeModule = null;
                            this.validated = false;
                            this.locale = 'default';
                            break;

                        case 'storefront:notify':
                            App.ui.notify(data.message, data.status, data.timeout);
                            break;

                        case 'storefront:edit':

                            if (!Storefront.modules[data.module]) {
                                return;
                            }

                            if (this.$refs.modulecomponent && this.$refs.modulecomponent.edit) {
                                this.$refs.modulecomponent.edit(data.id, data.context);
                            }

                            //Storefront.modules[data.module].edit(data.id, data.context, this.modules[data.module], this.locale);

                            break;
                    }

                }, false);

                document.addEventListener('visibilitychange', () => {

                    if (document.hidden) {
                        return;
                    }

                    this.reloadIframe();

                }, false);

            },

            methods: {
                updateSrc(e) {
                    //console.log(e.target)
                },

                reloadIframe() {
                    this.$refs.preview.contentWindow.location.reload();
                },

                highlight(item) {
                    this.send('storefront:highlight', item);
                },

                send(event, data) {
                    this.$refs.preview.contentWindow.postMessage({event, data: JSON.parse(JSON.stringify(data || {}))}, '*');
                },

                handleError() {
                    console.log(11)
                }
            }
        }

    </script>

</vue-view>
