<kiss-container class="kiss-margin-large">

    <ul class="kiss-breadcrumbs">
        <li><a href="<?=$this->route('/pages/settings')?>"><?=t('Settings')?></a></li>
    </ul>

    <vue-view class="kiss-margin-large-top">

        <template>

            <kiss-row class="kiss-margin-large" gap="large" :class="{'kiss-disabled': saving}">
                <div class="kiss-flex-1">

                    <kiss-card class="kiss-padding-small kiss-overlay-input kiss-flex kiss-flex-middle kiss-width-1-3@m kiss-margin" theme="bordered contrast">
                        <div class="kiss-margin-small-end"><icon class="kiss-size-1 kiss-color-muted">dialpad</icon></div>
                        <div>
                        <span class="kiss-text-caption kiss-color-muted">Group</span>
                        <div class="kiss-color-muted">{{ t(group || 'All fields') }}</div></div>
                            <select v-model="group">
                                <option :value="null">All</option>
                                <hr />
                                <optgroup label="<?=t('General')?>">
                                    <option value="SEO"><?=t('SEO')?></option>
                                    <option value="Images"><?=t('Images')?></option>
                                    <option value="Scripts"><?=t('Scripts')?></option>
                                    <option value="Preview"><?=t('Preview')?></option>
                                    <option value="Meta"><?=t('Meta')?></option>
                                </optgroup>
                                <?php if($this->module('layout')):?>
                                <optgroup label="<?=t('Layout')?>">
                                    <option value="Components"><?=t('Allowed components')?></option>
                                </optgroup>
                                <?php endif ?>
                            </select>
                    </kiss-card>

                    <div>

                        <app-fieldcontainer class="kiss-margin-large" v-if="!group || group == 'SEO'">

                            <label class="kiss-size-5 kiss-flex kiss-flex-middle">
                                <icon class="kiss-size-4 kiss-margin-small-end" size="larger">saved_search</icon>
                                <span><?=t('SEO')?></span>
                                <icon class="kiss-margin-xsmall-start">language</icon>
                            </label>

                            <div class="kiss-margin" v-for="locale in visibleLocales">

                                <span class="kiss-badge kiss-badge-outline kiss-color-primary" v-if="locales.length > 1">{{ locale.i18n }}</span>

                                <field-seo class="kiss-margin" v-model="settings['seo'+(locale.i18n!='default' ? '_'+locale.i18n:'')]"></field-seo>
                            </div>

                        </app-fieldcontainer>

                        <app-fieldcontainer class="kiss-margin-large" v-if="!group || group == 'Images'">

                                <label class="kiss-size-5 kiss-flex kiss-flex-middle">
                                    <icon class="kiss-size-4 kiss-margin-small-end" size="larger">photo_library</icon>
                                    <?=t('Images')?>
                                </label>

                                <div class="kiss-margin">
                                    <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom"><?=t('Logo')?></div>
                                    <field-asset v-model="settings.images.logo"></field-asset>
                                </div>
                                <div class="kiss-margin">
                                    <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom"><?=t('Small logo')?></div>
                                    <field-asset v-model="settings.images.small"></field-asset>
                                </div>
                                <div class="kiss-margin">
                                    <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom"><?=t('Favicon')?></div>
                                    <field-asset v-model="settings.images.favicon"></field-asset>
                                </div>

                        </app-fieldcontainer>

                        <app-fieldcontainer class="kiss-margin-large" v-if="!group || group == 'Scripts'">

                                <label class="kiss-size-5 kiss-flex kiss-flex-middle">
                                    <icon class="kiss-size-4 kiss-margin-small-end" size="larger">code</icon>
                                    <?=t('Scripts')?>
                                </label>

                                <div class="kiss-margin">
                                    <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom"><?=t('Header')?></div>
                                    <field-code v-model="settings.scripts.header" mode="html" height="150"></field-code>
                                </div>
                                <div class="kiss-margin">
                                    <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom"><?=t('Footer')?></div>
                                    <field-code v-model="settings.scripts.footer" mode="html" height="150"></field-code>
                                </div>

                        </app-fieldcontainer>

                        <app-fieldcontainer class="kiss-margin-large" v-if="!group || group == 'Preview'">

                            <label class="kiss-size-5 kiss-flex kiss-flex-middle">
                                <icon class="kiss-size-4 kiss-margin-small-end" size="larger">visibility</icon>
                                <?=t('Preview')?>
                            </label>

                            <kiss-card class="animated fadeIn kiss-padding kiss-align-center kiss-text-caption kiss-margin" theme="contrast" v-if="!settings.preview.length">
                                <div class="kiss-text-bold"><?=t('No content preview urls defined')?></div>
                            </kiss-card>

                            <vue-draggable class="kiss-margin" v-model="settings.preview" v-if="settings.preview.length" handle=".fm-handle">

                                <kiss-card class="kiss-flex kiss-flex-middle kiss-margin-small kiss-padding-small" gap="small" theme="bordered contrast" v-for="element in settings.preview">
                                    <a class="fm-handle kiss-color-muted"><icon>drag_handle</icon></a>
                                    <div class="kiss-width-1-4"><input type="text" class="kiss-input kiss-input-small" v-model="element.name" placeholder="<?=t('Name')?>"></div>
                                    <div class="kiss-flex-1"><input type="url" class="kiss-input kiss-input-small" v-model="element.uri" placeholder="https://..."></div>
                                    <a class="kiss-color-danger" @click="settings.preview.splice(settings.preview.indexOf(element), 1)"><icon>delete</icon></a>
                                </kiss-card>

                            </vue-draggable>

                            <div class="kiss-margin-small">
                                <button type="button" class="kiss-button kiss-button-small" @click="settings.preview.push({name:'', uri:''})"><icon class="kiss-margin-small-end">control_point</icon> {{ t('Add url') }}</button>
                            </div>

                        </app-fieldcontainer>

                        <app-fieldcontainer :caption="t('Meta')" v-if="!group || group == 'Meta'">

                            <label class="kiss-size-5 kiss-flex kiss-flex-middle">
                                <icon class="kiss-size-4 kiss-margin-small-end" size="larger">scatter_plot</icon>
                                <?=t('Meta')?>
                            </label>

                            <div class="kiss-margin">
                                <field-object v-model="settings.meta"></field-object>
                            </div>

                            <div class="kiss-text-bold kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom kiss-margin-top"><?=t('Global data')?></div>

                            <div>
                                <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom"><?=t('Global Data Fields for all page types')?></div>
                                <fields-manager v-model="settings.globalDataFields"></fields-manager>
                            </div>

                        </app-fieldcontainer>

                        <?php if($this->module('layout')):?>
                        <app-fieldcontainer class="kiss-margin-large" :caption="t('Layout')" v-if="!group || group == 'Components'">

                            <label class="kiss-size-5 kiss-flex kiss-flex-middle kiss-margin">
                                <icon class="kiss-size-4 kiss-margin-small-end" size="larger">scatter_plot</icon>
                                <?=t('Layout')?>
                            </label>

                            <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom"><?=t('Allowed Layout Components')?></div>

                            <div>
                                <field-tags v-model="settings.allowedLayoutComponents" placeholder="Add component..." :src="{
                                    route: '/layout/components?list=1',
                                    map: {
                                        value: 'name',
                                        label: 'label',
                                    }
                                }"></field-tags>
                            </div>

                        </app-fieldcontainer>
                        <?php endif; ?>

                    </div>
                </div>
                <div class="kiss-width-1-4@m">

                    <div class="kiss-margin">

                        <div class="kiss-text-caption kiss-size-xsmall kiss-text-bold">{{ t('Translation') }}</div>

                        <kiss-card class="kiss-padding-small kiss-margin-small kiss-text-muted kiss-size-small kiss-color-muted kiss-flex kiss-flex-middle" theme="bordered" v-if="locales.length == 1">
                            <span class="kiss-flex-1 kiss-margin-small-end">{{ t('No locales.') }}</span>
                            <a class="kiss-size-xsmall kiss-text-bolder" href="<?=$this->route('/system/locales')?>">{{ t('Manage') }}</a>
                        </kiss-card>

                        <div class="kiss-margin-small" v-if="locales.length > 1">

                            <kiss-card class="kiss-padding-small kiss-margin-xsmall kiss-text-bolder kiss-flex kiss-flex-middle" :class="{'kiss-color-muted': !loc.visible}" :theme="!loc.visible ? 'bordered':'bordered contrast'" v-for="loc in locales">
                                <div class="kiss-position-relative kiss-flex kiss-flex-middle kiss-flex-1">
                                    <icon class="kiss-margin-small-end" :class="{'kiss-color-primary': loc.visible}">{{ loc.visible ? 'visibility' : 'visibility_off' }}</icon>
                                    <span class="kiss-size-small kiss-flex-1">{{ loc.name }}</span>
                                    <span class="kiss-color-muted kiss-size-xsmall" v-if="loc.i18n == 'default'">{{ t('Default') }}</span>
                                    <a class="kiss-cover" @click="loc.visible = !loc.visible"></a>
                                </div>
                                <a class="kiss-margin-xsmall-start" v-if="loc.i18n != 'default'" @click="settings.locales[loc.i18n] = !settings.locales[loc.i18n]">
                                    <icon :class="{'kiss-color-danger':settings.locales[loc.i18n] === false}">{{settings.locales[loc.i18n] === false ? 'cloud_off': 'cloud'}}</icon>
                                </a>
                            </kiss-card>
                        </div>

                    </div>

                    <div class="kiss-margin">

                        <div class="kiss-text-caption kiss-size-xsmall kiss-text-bold">{{ t('Revisions') }}</div>

                        <kiss-row class="kiss-margin-small kiss-flex-middle">
                            <div class="kiss-size-small kiss-flex-1" :class="{'kiss-color-muted': !settings.revisions}">
                                <?=t('Store every page update as version')?>
                            </div>
                            <field-boolean v-model="settings.revisions"></field-boolean>
                        </kiss-row>

                    </div>

                </div>
            </kiss-row>

            <app-actionbar>

                <kiss-container>
                    <div class="kiss-flex kiss-flex-middle kiss-flex-end">

                        <button class="kiss-button kiss-button-primary" @click="save">
                            <?=t('Save settings')?>
                        </button>
                    </div>
                </kiss-container>

            </app-actionbar>

        </template>

        <script type="module">

            export default {

                data() {

                    let settings = <?=json_encode($settings)?>;

                    settings.globalDataFields = Array.isArray(settings.globalDataFields) ? settings.globalDataFields : [];

                    return {
                        settings,
                        locales: <?=json_encode($locales)?>,
                        saving: false,
                        group: null,
                    }
                },

                computed: {

                    visibleLocales() {
                        return this.locales.filter(l => l.visible);
                    }
                },

                methods: {

                    save() {

                        this.saving = true;

                        this.$request('/pages/settings/save', {settings: this.settings}).then(settings => {

                            this.saving = false;
                            App.ui.notify('Settings updated!');

                        }).catch(res => {
                            this.saving = false;
                            App.ui.notify(res.error || 'Saving failed!', 'error');
                        });
                    }
                }
            }

        </script>

    </vue-view>

</kiss-container>
