<?php

use GraphQL\Type\Definition\Type;
use GraphQL\Type\Definition\ObjectType;
use App\GraphQL\Types\JsonType;

$gql->queries['fields']['pagesMenus'] = [

    'type' => Type::listOf(JsonType::instance()),

    'args' => [
        'inactive'  => ['type' => Type::boolean(), 'defaultValue' => false],
        'locale'  => Type::string(),
    ],

    'resolve' => function ($root, $args) use($app) {

        if (!$app->helper('acl')->isAllowed('pages/api/read', $app->helper('auth')->getUser('role'))) {
            $app->response->status = 403;
            return [];
        }

        $locale = $args['locale'] ?? 'default';

        return $app->helper('locales')->applyLocales($app->module('pages')->menus(process: [
            'resolveLinks' => true,
            'filterInactiveLinks' => !($args['inactive'] ?? false)
        ]), $locale);
    }
];
