export default {
    _meta: {
        label: 'SEO',
        info: 'SEO meta info',
        icon: 'pages:assets/icons/seo.svg',
        render(value, field, context) {
            return (value && value.title) || '';
        }
    },

    data() {
        return {
            val: this.modelValue || {}
        }
    },

    props: {
        modelValue: {
            type: Object,
            default: {}
        },
    },

    watch: {
        val: {
            handler() { this.update() },
            deep: true
        },
        modelValue() {
            this.val = this.modelValue || {};
            this.update();
        }
    },

    methods: {

        update() {
            this.$emit('update:modelValue', this.val)
        }
    },

    template: /*html*/`
        <div field="seo">

            <div class="kiss-margin">
                <field-asset v-model="val.image"></field-asset>
            </div>

            <div class="kiss-margin-small">
                <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom">{{ t('Title') }}</div>
                <field-text v-model="val.title" :show-count="true"></field-text>
            </div>

            <div class="kiss-margin-small">
                <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom">{{ t('Keywords') }}</div>
                <field-text v-model="val.keywords" :show-count="true"></field-text>
            </div>

            <div class="kiss-margin-small">
                <div class="kiss-size-xsmall kiss-color-muted kiss-margin-small-bottom">{{ t('Description') }}</div>
                <field-text v-model="val.description" :multiline="true" :show-count="true"></field-text>
            </div>

            <kiss-row class="kiss-margin-small">
                <div>
                    <field-boolean v-model="val.noindex" :label="t('No index')"></field-boolean></div>
                <div>
                    <field-boolean v-model="val.nofollow" :label="t('No follow')"></field-boolean></div>
            </kiss-row>

        </div>
    `
}
