export default {

    data() {
        return {
            model: null,
            titleField: null,
        }
    },

    props: {
        page: {
            type: Object
        },
        locale: {
            type: String,
            default: 'default'
        }
    },

    computed: {
        items() {
            return this.page.data.items || [];
        },

        item() {
            return this.page.data.item|| null;
        }
    },

    mounted() {

        App.utils.getContentModels().then(models => {

            this.model = false;

            if (models[this.page.data.collection]) {

                this.model = models[this.page.data.collection];

                let fields = this.model.fields.map(field => field.name);

                if (fields.includes('title')) {
                    this.titleField = 'title';
                } else if (fields.includes('name')) {
                    this.titleField = 'name';
                } else if (fields.includes('label')) {
                    this.titleField = 'label';
                } else {

                    for (let field of this.model.fields) {
                        if (field.required && field.type == 'text' && !field.opts.multiline) {
                            this.titleField = field.name;
                            break;
                        }
                    }
                }
            }
        });
    },

    methods: {
        getItemTitle(item) {
            return item.item[this.titleField] || 'n/a';
        }
    },

    template: /*html*/`
        <kiss-card>
            <app-loader size="small" mode="dots" v-if="!model"></app-loader>
            <div class="kiss-size-small" v-if="model">

                <div class="kiss-text-caption kiss-size-xsmall kiss-color-muted kiss-margin-xsmall-bottom">
                    {{ model.label || model.name }}
                </div>

                <div v-if="items.length">
                    <kiss-card class="kiss-margin-small kiss-padding-small kiss-flex kiss-flex-middle kiss-visible-toggle" hover="contrast" theme="bordered" gap="small" v-for="item in items">
                        <icon>article</icon>
                        <div class="kiss-text-truncate kiss-flex-1">{{ getItemTitle(item) }}</div>
                        <a class="animated fadeInRight faster kiss-hidden-hover" :href="$routeUrl('/content/'+model.type+'/item/'+page.data.collection+'/'+item.item._id)" target="_blank"><icon>edit</icon></a>
                    </kiss-card>
                </div>

                <kiss-card class="kiss-margin-small kiss-padding-small kiss-flex kiss-flex-middle kiss-visible-toggle" hover="contrast" theme="bordered" gap="small" v-if="item">
                    <icon>article</icon>
                    <div class="kiss-text-truncate kiss-flex-1">{{ getItemTitle(item) }}</div>
                    <a class="animated fadeInRight faster kiss-hidden-hover" :href="$routeUrl('/content/'+model.type+'/item/'+page.data.collection+'/'+item._id)" target="_blank"><icon>edit</icon></a>
                </kiss-card>

            </div>
        </kiss-card>
    `
}
