export default {

    data() {
        return {
            data: null
        }
    },

    props: {
        page: {
            type: Object,
            default: null
        },
        locale: {
            type: String,
            default: 'default'
        },
        componentMap: {
            type: Object,
            default: () => ({})
        }
    },

    components: {
        collectionPanel: Vue.defineAsyncComponent(() =>
            App.utils.import('pages:assets/storefront/admin/modules/pages/vue-components/type-collection.js')
        ),
    },

    mounted() {
        this.load();
    },

    computed: {
        title() {

            if (this.locale !== 'default' && this.data.page[`title_${this.locale}`]) {
                return `${this.data.page[`title_${this.locale}`]}`;
            }

            return this.data.page.title;
        }
    },

    methods: {
        load() {

            this.$request(`/pages/page/${this.page._id}/true`, {

            }).then((data) => {
                this.data = data;
            }).catch((err) => {
                console.error(err);
            });
        },

        highlight(id) {

            if (!this.componentMap[id]) return;

            this.$emit('highlight', this.componentMap[id]);
        }
    },

    template: /*html*/`
        <kiss-card class="kiss-padding-small kiss-visible-toggle" theme="contrast bordered">
            <app-loader size="small" mode="dots" v-if="!data"></app-loader>
            <div class="kiss-size-small" v-if="data">
                <div class="kiss-text-caption kiss-size-xsmall kiss-color-muted kiss-margin-xsmall-bottom">{{ data.page.type }}</div>
                <div class="kiss-flex" gap="small">
                    <strong class="kiss-flex-1 kiss-text-truncate">{{ title }}</strong>
                    <a class="animated fadeInRight faster kiss-hidden-hover" :href="$routeUrl('/pages/page/'+page._id)" target="_blank"><icon>edit</icon></a>
                </div>

                <div class="kiss-margin-top" v-if="data.page.type == 'layout' && data.page.data && data.page.data.length">
                    <div class="kiss-text-caption kiss-text-bold kiss-color-muted kiss-margin-xsmall-bottom">{{ t('Components') }}</div>
                    <div class="kiss-margin-xsmall-bottom kiss-padding-xsmall kiss-bgcolor-contrast kiss-flex kiss-flex-middle kiss-corner-small" v-for="component in data.page.data" @mouseenter="highlight(component.id)">
                        <div class="kiss-size-xsmall kiss-text-truncate kiss-flex-1">{{ component.label || component.component }}</div>
                        <icon class="kiss-color-muted kiss-size-4" v-if="componentMap[component.id]">visibility</icon>
                    </div>
                </div>
            </div>
        </kiss-card>

        <collection-panel class="kiss-margin" :page="page" v-if="page.type == 'collection'" :locale="locale"></collection-panel>
    `
}
