export default {

    data() {
        return {
            data: null
        }
    },

    props: {
        project: {
            type: String,
            default: null
        }
    },

    mounted() {
        this.load();
    },

    methods: {
        load() {

            this.$request(`/lokalize/projects/project/${this.project.name}/true`).then((data) => {
                console.log(data);
                this.data = data;
            }).catch((err) => {
                console.error(err);
            });
        }
    },

    template: /*html*/`
        <kiss-card>
            <app-loader size="small" mode="dots" v-if="!data"></app-loader>
            <div class="kiss-size-small kiss-flex kiss-flex-middle" v-if="data" :style="{color: data.color || 'inherit' }">
                <kiss-svg class="kiss-margin-small-end" :src="$baseUrl(data.icon || 'lokalize:icon.svg')" width="20" height="20"><canvas width="20" height="20"></canvas></kiss-svg>
                {{ data.label || data.name  }}
            </div>
        </kiss-card>
    `
}
