// Global Vue components
VueView.component('field-pageUrl', 'pages:assets/vue-components/field-page-url.js');
VueView.component('field-seo', 'pages:assets/vue-components/field-seo.js');
VueView.component('field-collectionpageitems', 'pages:assets/vue-components/field-collectionpageitems.js');


App.on('field-richtext-init', evt => {
    let editor = evt.params[0];

    editor.extensionManager.extensions.forEach(ext => {
        switch (ext.name) {
            case 'link':
                ext.options.protocols.push('pages')
                break;
        }
    });
});

App.on('field-richtext-link-sources', evt => {
    let link = evt.params[0];

    link.sources['Pages'] = () => {

        VueView.ui.offcanvas('pages:assets/dialogs/page-picker.js', {}, {

                select: (page, locale) => {

                    link.href = `pages://${page._id}`+((locale && locale != 'default' && `?locale=${locale}`) || '');
                }

        });
    };
});

App.utils.selectPage = function(callback, opts = {}, flip = true) {

    VueView.ui.offcanvas('pages:assets/dialogs/page-picker.js', opts, {

        select: (page, locale) => {
            callback(page, locale);
        }

    }, {flip});
}
