let PageTree = {

    name: 'page-tree',

    data() {
        return {
            loading: false
        }
    },

    props: {
        pages: {
            type: Array,
            default: []
        },
        level: {
            type: Number,
            default: 0
        },
        locale: {
            type: String,
            default: 'default'
        },
        p: {
            type: Object,
            default: null
        }
    },

    mounted() {

        if (this.p && this.p._children) {

            this.loading = true;

            let params = {_pid:this.p._id};

            if (this.locale && this.loacale !== 'default') {
                params.locale = this.locale;
            }

            this.$request('/pages/load', params).then(pages => {

                this.p.children = pages;
                this.loading = false;
            }).catch(res => {
                this.loading = false;
                App.ui.notify(res.error || 'Loading children failed!', 'error');
            });
        }
    },

    template: /*html*/`
        <div>

            <app-loader size="small" v-if="loading"></app-loader>

            <div v-if="!loading">

                <div v-for="page in pages">
                    <div class="kiss-margin-xsmall-top">
                        <kiss-card class="kiss-flex kiss-flex-middle kiss-padding-xsmall kiss-margin-xsmall kiss-visible-toggle" theme="bordered shadowed" hover="contrast">
                            <a class="kiss-margin-small-end kiss-color-muted" :class="{'kiss-hidden': !page._children}" :placeholder="t('Toggle children')" @click="page._showChildren = !page._showChildren">
                                <icon>{{ page._showChildren ? 'indeterminate_check_box' : 'add_box' }}</icon>
                            </a>
                            <div class="kiss-margin-small-end">
                                <icon :class="{'kiss-color-danger': !page._state, 'kiss-color-success': page._state === 1}">circle</icon>
                            </div>
                            <div class="kiss-position-relative kiss-flex-1 kiss-size-small kiss-text-truncate" :class="{'kiss-text-bold': page._children}">
                                {{ page.title }}
                                <a class="kiss-cover" @click="select(page)"></a>
                            </div>
                        </kiss-card>
                        <div v-if="page._showChildren || !page._children" :style="{paddingLeft: (((level+1)*24)+'px')}">
                            <page-tree class="pages-tree" :pages="page.children" :level="level+1" :p="page" :locale="locale" @pickPage="pickedPage"></page-tree>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    `,

    methods: {

        pickedPage(data) {
            this.select(data.page)
        },

        select(page) {
            this.$emit('pick-page', {page})
        }
    }
}

export default {

    _meta: {flip: true, size: 'large'},

    data() {
        return {
            pages: [],
            loading: false,
            i18n: this.locale || 'default',
            pageType: null,
            pageTypes: null,
            filter: '',
            txtFilter: '',
        }
    },

    props: {
        locale: {
            type: String,
            default: 'default'
        },
        title: {
            type: String,
            default: 'Select page'
        }
    },

    components: {
        PageTree
    },

    mounted() {
        this.load();

        this.$request('/pages/utils/pageTypes', {}).then(pageTypes => {
            this.pageTypes = pageTypes;
        }).catch(res => {
            App.ui.notify(res.error || 'Loading page types failed!', 'error');
        });
    },

    computed: {
        isFiltered() {
            return this.pageType || this.filter;
        }
    },

    watch: {
        filter(val) {
            this.txtFilter = val;

            if (val || this.pageType) {
                this.find();
            } else {
                this.load();
            }
        },
        i18n() {

            if (this.pageType || this.filter) {
                this.find();
            } else {
                this.load();
            }
        },
        pageType() {

            if (this.pageType || this.filter) {
                this.find();
            } else {
                this.load();
            }
        }
    },

    template: /*html*/`
        <form class="app-offcanvas-container">
            <div class="kiss-padding kiss-text-bold kiss-flex kiss-flex-middle" gap="small">
                <div><icon size-larger>link</icon></div>
                <div class="kiss-flex-1">{{ t(this.title) }}</div>
            </div>

            <form class="kiss-padding kiss-bgcolor-contrast" :class="{'kiss-disabled': loading}" @submit.prevent="filter = txtFilter">
                <div class="kiss-flex" gap="small">
                    <input type="text" class="kiss-input kiss-input-small" :placeholder="t('Filter pages...')" v-model="txtFilter">
                    <div class="kiss-button-group">
                        <button type="button" class="kiss-button kiss-button-small" @click="filter = ''" v-if="filter">{{ t('Reset') }}</button>
                        <button class="kiss-button kiss-button-small"><icon>search</icon></button>
                    </div>
                </div>
                <div class="kiss-flex kiss-margin-small-top" gap>
                    <div class="kiss-overlay-input" v-if="Object.keys(App._locales).length > 1">
                        <span class="kiss-text-caption kiss-size-xsmall kiss-color-muted">{{ t('Locale') }}</span>
                        <div class="kiss-size-small" :class="{'kiss-color-muted': locale == 'default', 'kiss-color-primary': locale != 'default'}">{{ App._locales[i18n] }}</div>
                        <select v-model="i18n"><option :value="vi18n" v-for="(label,vi18n) in App._locales">{{label}}</option></select>
                    </div>
                    <div class="kiss-overlay-input" v-if="pageTypes">
                        <span class="kiss-text-caption kiss-size-xsmall kiss-color-muted">{{ t('Page Type') }}</span>
                        <div class="kiss-size-small" :class="{'kiss-color-muted': !pageType, 'kiss-color-primary': pageType}">{{ pageType ? (pageTypes[pageType] ? (pageTypes[pageType].label || pageType) : pageType) : t('All types')  }}</div>
                        <select v-model="pageType">
                            <option value="">{{ t('All') }}</option>
                            <hr>
                            <option :value="ptype" v-for="(pmeta, ptype) in pageTypes">{{ pmeta.label ?? ptype }}</option>
                        </select>
                    </div>
                </div>
            </form>
            <div class="app-offcanvas-content kiss-padding kiss-bgcolor-contrast">

                <app-loader size="small" v-if="loading"></app-loader>

                <div class="animated fadeIn kiss-height-50vh kiss-flex kiss-flex-middle kiss-flex-center kiss-align-center kiss-color-muted" v-if="!loading && pages && !pages.length">
                    <div>
                        <kiss-svg :src="$baseUrl('pages:icon.svg')" width="40" height="40"><canvas width="40" height="40"></canvas></kiss-svg>
                        <p class="kiss-size-large kiss-margin-small-top">{{ t('No pages') }}</p>
                    </div>
                </div>

                <div v-if="!loading && isFiltered && Array.isArray(pages) && pages.length">

                    <div class="kiss-margin-small kiss-text-caption kiss-color-muted">{{ t('Filtered pages') }}</div>

                    <div class="kiss-margin-xsmall" v-for="page in pages">
                        <kiss-card class="kiss-flex kiss-flex-middle kiss-padding-xsmall kiss-margin-xsmall kiss-visible-toggle" theme="bordered shadowed" hover="contrast">
                            <div class="kiss-margin-small-end">
                                <icon :class="{'kiss-color-danger': !page._state, 'kiss-color-success': page._state === 1}">circle</icon>
                            </div>
                            <div class="kiss-flex-1 kiss-size-small kiss-text-truncate kiss-visible-toggle">
                                {{ page.title }}
                            </div>
                            <a class="kiss-invisible-hover kiss-size-5 kiss-badge" @click="select(page)"><icon>link</icon></a>
                        </kiss-card>
                    </div>
                </div>

                <div v-if="!loading && !isFiltered && Array.isArray(pages) && pages.length">
                    <page-tree :pages="pages" :locale="i18n" v-if="!loading" @pickPage="(data) => select(data.page)"></page-tree>
                </div>
            </div>
        </div>
    `,

    methods: {
        select(page) {
            this.$call('select', page, this.i18n);
            this.$close();
        },

        load() {

            this.loading = true;

            this.$request('/pages/load', {_pid:{}, locale: this.i18n}).then(pages => {
                this.pages = pages;
                this.loading = false;
            }).catch(res => {
                this.loading = false;
                App.ui.notify(res.error || 'Loading failed!', 'error');
            });
        },

        find() {

            let options = {
                filter: this.filter,
                limit: 20
            };

            if (this.i18n !== 'default') {
                options.locale = this.i18n;
            }

            if (this.pageType) {
                options.pageType = this.pageType;
            }

            this.loading = true;

            this.$request('/pages/utils/find', {options}).then(res => {
                this.pages = res.items;
            }).catch(res => {
                App.ui.notify(res.error || 'Loading failed!', 'error');
            }).finally(() => {
                this.loading = false;
            });
        },

    }
}
