export default {

    _meta: {flip: true, size: 'large'},

    data() {

        return {
            types: this.pageTypes || null,
            loading: false
        }
    },

    props: {
        pageTypes: {
            type: Object
        },

        pid: {
            type: String
        }
    },

    computed: {
        groups() {

            let groups = {
                '' : []
            };

            let group;

            Object.values(this.types || []).forEach(t => {

                group = t.group || '';

                if (!groups[group]) {
                    groups[group] = [];
                }

                groups[group].push(t);
            });

            return groups;
        }
    },

    template: /*html*/`

        <div class="app-offcanvas-container">
            <div class="kiss-padding kiss-text-bold">
                {{ t('Choose page type') }}
            </div>
            <div class="app-offcanvas-content kiss-padding kiss-bgcolor-contrast kiss-flex-1">

                <app-loader v-if="loading"></app-loader>

                <div v-if="types">

                    <div class="kiss-margin" v-for="(groupTypes,group) in groups">

                        <div class="kiss-text-caption kiss-color-muted kiss-size-small kiss-margin-small" v-if="group.trim()">{{ group }}</div>

                        <kiss-grid cols="2@m" gap="small" v-if="types">
                            <kiss-card class="kiss-padding-small kiss-flex kiss-flex-middle kiss-position-relative" theme="contrast bordered" hover="shadow" v-for="pageType in groupTypes">
                                <div>
                                    <kiss-svg class="kiss-color-primary" :src="$baseUrl(pageType.icon || 'pages:icon.svg')" width="30" height="30"><canvas width="30" height="30"></canvas></kiss-svg>
                                </div>
                                <div class="kiss-flex-1 kiss-margin-small-start kiss-size-small">
                                    <strong>{{pageType.label || pageType.name}}</strong>
                                </div>
                                <a class="kiss-cover" :href="$routeUrl('/pages/page?type=')+pageType.name+'&pid='+(pid || '')"></a>
                            </kiss-card>
                        </kiss-grid>

                    </div>

                </div>

            </div>
            <div class="kiss-padding kiss-bgcolor-contrast">
                <button class="kiss-button kiss-width-1-1" kiss-offcanvas-close>{{ t('Cancel') }}</button>
            </div>
        </div>
    `,

    mounted() {

        if (!this.pageTypes) {

            this.loading = true;

            this.$request('/pages/utils/pageTypes').then(pageTypes => {
                this.types = pageTypes;
                this.loading = false;
            });
        }
    },

    methods: {

    }
}
