<?php

$this->helper('license')->require();

// Register routes
$this->bindClass('Pages\\Controller\\Menus', '/pages/menus');
$this->bindClass('Pages\\Controller\\Settings', '/pages/settings');
$this->bindClass('Pages\\Controller\\Storefront', '/pages/storefront');
$this->bindClass('Pages\\Controller\\Utils', '/pages/utils');
$this->bindClass('Pages\\Controller\\Pages', '/pages');

// events
$this->on('app.layout.assets', function(array &$assets, $context) {
    if ($context === 'app:footer') $assets[] = ['src' => 'pages:assets/js/pages.js', 'type' => 'module'];
});

$this->on('app.layout.init', function() {

    if (!$this->helper('acl')->isAllowed('pages/manage')) {
        return;
    }

    $this->helper('menus')->addLink('modules', [
        'label'  => 'Pages',
        'icon'   => 'pages:icon.svg',
        'route'  => '/pages',
        'active' => false,
        'group'  => 'Content',
        'prio'   => 1
    ]);
});

$this->on('app.settings.collect', function($settings) {

    $settings['Addons'][] = [
        'icon' => 'pages:icon.svg',
        'route' => '/pages/settings',
        'label' => 'Pages',
        'permission' => 'pages/manage'
    ];
});


$this->on('app.permissions.collect', function($permissions) {

    $permissions['Pages'] = [
        'pages/manage' => 'Manage pages',
        'pages/api/read' => 'API access',
    ];
});

$this->on('app.search', function($search, $findings) {

    if (!$this->helper('acl')->isAllowed('pages/manage')) {
        return;
    }

    $filter = [
        '$or' => [
            ['title' => ['$regex' => $search, '$options' => 'i']],
            ['slug' => ['$regex' => $search, '$options' => 'i']]
        ]
    ];

    // search in all locales
    $locales = array_keys($this->helper('locales')->locales(true));

    foreach ($locales as $locale) {
        if ($locale == 'default') continue;
        $filter['$or'][] = ["title_{$locale}" => ['$regex' => $search, '$options' => 'i']];
        $filter['$or'][] = ["slug_{$locale}" => ['$regex' => $search, '$options' => 'i']];
    }

    $pages = $this->dataStorage->find('pages', [
        'filter' => $filter,
        'limit' => 5
    ])->toArray();

    foreach ($pages as $page) {

        $findings[] = [
            'title' => $page['title'],
            'route' => $this->routeUrl("/pages/page/{$page['_id']}"),
            'group' => 'Pages',
            'icon' => 'pages:icon.svg',
            'context' => ucfirst($page['type'])
        ];
    }

    $menus = $this->dataStorage->find('pages/menus', [
        'filter' => [
            'name' => ['$regex' => $search, '$options' => 'i']
        ],
        'fields' => ['data' => 0, '_meta' => 0]
    ])->toArray();

    foreach ($menus as $menu) {

        $findings[] = [
            'title' => isset($menu['label']) && $menu['label'] ? "{$menu['label']} ({$menu['name']})" : $menu['name'],
            'route' => $this->routeUrl("/pages/menus/menu/{$menu['name']}"),
            'group' => 'Pages',
            'icon' => 'pages:assets/icons/nav.svg'
        ];
    }
});

$this->on('layout.shared.remove', function($component) {
    $pages = $this->dataStorage->findTerm('pages', $component['_id'])->toArray();
    $pages = count($pages) ? $this->helper('layoutComponents')->removeSharedComponents($pages, $component['_id']) : [];
    foreach ($pages as $page) $this->dataStorage->save('pages', $page);
});

$this->on('app.dashboard.widgets', function($widgets) {

    if (!$this->helper('acl')->isAllowed('pages/manage') || !$this->dataStorage->count('pages')) {
        return;
    }

    $widgets[] = [
        'name' => 'dashboard-pages-widget',
        'area' => 'tertiary',
        'prio' => 10,
        'component' => 'pages:assets/vue-components/dashboard-widget.js',
    ];

});
